@extends('layouts.admin')
<title>{{ trans('home.partner_requests') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.partners') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('partners.index') }}">{{ trans('home.partners') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.partner_requests') }}</li>
                </ol>
            </div>

            @can('partner_requests_operations')
                <div class="btn btn-list">
                    @can('partner_requests_accept_button')
                        <a id="btn_active_partner"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                                {{ trans('home.accept') }}</button>
                        </a>
                    @endcan
                    @can('partner_requests_delete_button')
                        <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                                {{ trans('home.delete') }}</button></a>
                    @endcan
                </div>
            @endcan
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.partners') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>
                        <div class="table-responsive">
                            
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th class="wd-20p">{{ trans('home.name') }}</th>
                                        <th class="wd-20p">{{ trans('home.center') }}</th>
                                        <th class="wd-25p">{{ trans('home.partner_status') }}</th>
                                        <th class="wd-25p">{{ trans('home.status') }}</th>
                                        <th class="wd-25p">{{ trans('home.seen') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($partners as $partner)
                                        <tr id="{{ $partner->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" value="{{ $partner->id }}" /> </td>
                                            <td><a href="javascript::void(0)">{{ $partner->user->id }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ $partner->user->name() }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ $partner->center_name }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ $partner->user->verified_partner==1? __('home.active') : __('home.inactive') }}</a>  </td>
                                            <td><a  href="javascript::void(0)">{{ $partner->user->status==1? __('home.active') : __('home.inactive') }}</a> </td>
                                            <td><a  href="javascript::void(0)">{{ $partner->seen==1? __('home.seen') : __('home.not_seen') }}</a> </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
<script>
    $(document).ready(function(){
        $('#btn_active_partner').click(function(){
            var id = [];
            $('.tableChecked:checked').each(function(i){
                id[i] = $(this).val();
            });
            
            if(id.length === 0) //tell you if the array is empty
            {
                alert("Please Select at least one checkbox");
            }
            else
            {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo url('admin/partners_requests_change_status')?>", 
                    method:'POST',
                    data:{id:id},
                    success:function(data)
                    {
                        // console.log(data);
                        location.reload();
                    }
                });
            }
        });
    });
</script>
    

@endsection