@extends('layouts.admin')
<title>{{ trans('home.partner_training_requests') }}</title>
@section('content')

    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.partner_training_requests') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('partners.index') }}">{{ trans('home.partners') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.partner_training_requests') }}</li>
                </ol>
            </div>
            @can('partner_trainings_requests_operations')
                <div class="btn btn-list">
                    @can('partner_trainings_requests_accept_button')
                        <a class="mr-2" id="btn_delivered_partner"><button class="btn ripple btn-info"><i class="fas fa-check"></i>
                                {{ trans('home.request_delivered') }}</button>
                        </a>
                        <a class="mr-2" id="btn_processing_partner"><button class="btn ripple btn-dark"><i class="fas fa-spinner" style="color: #fafafa;"></i>
                                {{ trans('home.processing') }}</button>
                        </a>
                        <a class="mr-2" id="btn_accepted_partner"><button class="btn ripple btn-success"><i class="fas fa-check-double"></i>
                                {{ trans('home.request_accepted') }}</button>
                        </a>
                        <a class="mr-2" id="btn_edited_partner"><button class="btn ripple btn-primary"><i class="fas fa-edit"></i>
                                    {{ trans('home.request_edited') }}</button>
                        </a>
                    @endcan
                    @can('partner_trainings_requests_delete_button')
                        <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                                {{ trans('home.delete') }}</button></a>
                    @endcan
                </div>
            @endcan
        </div>
        <!-- End Page Header -->
        
        @if(session()->has('edit_success'))
            <div class="alert alert-success">
                {{ session()->pull('edit_success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <h6 class="card-title mb-1">{{ trans('home.partner_training_requests') }}</h6>
                                <p class="text-muted card-sub-title">
                                    {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                            </div>
                            <div class="col-md-4 text-center row">
                                <label class="mb-2 col-md-12" style="padding-left:120px">{{trans('home.code')}}</label>
                                <input class="form-control text-center col-md-3" id="training_code3" name="training_code3" type="number" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 3)"  >
                                <input class="form-control text-center col-md-1" id="training_code"  name="training_code" value="-" type="text"  placeholder="{{trans('home.code')}}" readonly>
                                <input class="form-control text-center col-md-5" id="training_code5" name="training_code5" type="number" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 5)"  >
                            </div>
                        </div>
                        
                        <div class="table-responsive">
                            
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th class="wd-25p">{{ trans('home.created_at') }}</th>
                                        <th class="wd-20p">{{ trans('home.name') }}</th>
                                        <th class="wd-20p">{{ trans('home.center') }}</th>
                                        <th class="wd-25p">{{ trans('home.training') }}</th>
                                        <th class="wd-25p">{{ trans('home.field') }}</th>
                                        <th class="wd-25p">{{ trans('home.region') }}</th>
                                        <th class="wd-25p">{{ trans('home.time_from') }}</th>
                                        <th class="wd-25p">{{ trans('home.time_to') }}</th>
                                        <th class="wd-25p">{{ trans('home.date_from') }}</th>
                                        <th class="wd-25p">{{ trans('home.date_to') }}</th>
                                        <th class="wd-25p">{{ trans('home.n_students') }}</th>
                                        <th class="wd-25p">{{ trans('home.request_type') }}</th>
                                        <th class="wd-25p">{{ trans('home.request_status') }}</th>
                                        <th class="wd-25p">{{ trans('home.exception_or_not') }}</th>
                                        <th class="wd-25p">{{ trans('home.exception_file') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($partner_requests as $partner_request)
                                        <tr id="{{ $partner_request->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" data-request_type="{{$partner_request->request_type}}" value="{{ $partner_request->id }}" /> </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal"  data-partner_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->id }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->created_at }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->user->name() ?? '....' }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->center->{'name_'.$lang} ?? '....' }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->{'name_'.$lang} }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->field->{'name_'.$lang} ?? '' }}</a>  </td>
                                                
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->hall->region->{'name_'.$lang} ?? '....' }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->time_from }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->time_to }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                {{ \Carbon\Carbon::parse($partner_request->start_date)->format("Y-m-d") }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                {{ \Carbon\Carbon::parse($partner_request->end_date)->format("Y-m-d") }}</a>  </td>
                                                
                                                
                                            <td><a href="javascript:void(0);" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                {{ $partner_request->n_students }}</a>  </td>
                                            
                                            <td><a href="javascript:void(0);" id="{{'status_'.$partner_request->id}}" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                @if($partner_request->request_type== 'new')
                                                    <span class="badge badge-danger">{{__('home.new_request')}} <i class="fas fa-plus"></i></span>
                                                @elseif($partner_request->request_type== 'edit')
                                                    <span class="badge badge-info">{{__('home.edit_request')}} <i class="fas fa-edit"></i></span>
                                                @elseif($partner_request->request_type== 'exception')
                                                    <span class="badge badge-warning">{{__('home.exception_request')}} <i class="fas fa-edit"></i></span>
                                               @endif
                                                </a> </td>
                                            <td><a href="javascript:void(0);" id="{{'status_'.$partner_request->id}}" class="show_detials" data-toggle="modal" data-target="#trainingPartnerRequestmodel" data-partner_request_id="{{$partner_request->id}}">
                                                @if($partner_request->status== 'delivered')
                                                    <span class="badge badge-info">{{__('home.request_delivered')}} <i class="fas fa-check"></i></span>
                                                @elseif($partner_request->status== 'processing')
                                                    <span class="badge badge-dark">{{__('home.processing')}} <i class="fas fa-spinner" style="color: #fafafa;"></i></span>
                                                @elseif($partner_request->status== 'accepted')
                                                    <span class="badge badge-success">{{__('home.request_accepted')}} <i class="fas fa-check-double"></i></span><br><span class="mt-1 badge badge-danger">{{ trans('home.code') . ': ' }} <span class="d-inline-block">{{$partner_request->training_code}}</span></span>
                                                @elseif($partner_request->status== 'edited')
                                                    <span class="badge badge-primary">{{__('home.request_edited')}} <i class="fas fa-edit"></i></span><br><span class="mt-1 badge badge-danger">{{ trans('home.code') . ': ' }} <span class="d-inline-block">{{$partner_request->training_code}}</span></span>
                                                @endif
                                                </a> </td>
                                            <td>
                                                @if($partner_request->exception_or_not)
                                                         {{ __('home.'.$partner_request->exception_or_not)}}
                                                @endif
                                            </td>
                                            <td>
                                                @if($partner_request->exception_file)
                                                    <a href="{{url('uploads/partner_trainin_request/files/'.$partner_request->exception_file)}}" download="{{url('uploads/partner_trainin_request/files/'.$partner_request->exception_file)}}">
                                                          <i class="fas fa-download"></i>
                                                          {{$partner_request->exception_file}}
                                                    </a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                           
                        </div>
                    </div>
                </div>
            </div>
            
                {{-- <!-- ask_for_adding_new_training as partner  -->
                    <div class="modal fade bd-example-modal-lg" id="trainingPartnerRequestmodel" style="z-index:99999" tabindex="-1" role="dialog" aria-labelledby="trainingPartnerRequestmodelTitle" aria-hidden="true">
              <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content" style="border-radius: 35px;">
                  <div class="modal-header">
                     <h5 class="m-auto">{{__('home.training_request_details')}}</h5>
                  </div>
                <form method="post" action="#" enctype="multipart/form-data">
                  <div class="modal-body ">
                        <div class="m-auto">
                            @csrf
                            
                                <div class="row m-2">
        
                                    <div class="form-group col-md-3">
                                        <label class="">{{trans('home.name_en')}}</label>
                                        <input class="form-control @error('name_en') is-invalid @enderror" name="name_en" value="{{$partner_request->name_en ?? ''}}" disabled type="text" placeholder="{{trans('home.name_en')}}">
                                        @error('name_en')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group col-md-3">
                                        <label class="">{{trans('home.name_ar')}} </label>
                                        <input class="form-control @error('name_ar') is-invalid @enderror" name="name_ar" value="{{$partner_request->name_ar ?? ''}}" disabled type="text" placeholder="{{trans('home.name_ar')}}" required>
                                        @error('name_ar')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-3">
                                        
                                        <label class="">{{trans('home.n_students')}}</label>
                                        <input class="form-control" name="n_students" type="number" value="{{$partner_request->n_students ?? ''}}" disabled placeholder="{{trans('home.n_students')}}" required>
                                    </div>
                                       <div class="form-group col-md-3">
                                        <label for="training_type">{{trans('home.training_type')}}</label>
                                        <select class="form-control select2" name="training_type" disabled>
                                            <option @selected($partner_request->training_type == "online")>{{trans('home.online')}}</option>
                                            <option @selected($partner_request->training_type == 'offline')>{{trans('home.offline')}}</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label class="">{{trans('home.address').' /url' }}</label>
                                        <input class="form-control" name="address" type="text" value="{{$partner_request->address ?? ''}}" disabled placeholder="{{trans('home.address')}}" >
                                    </div>
                                    
                                    <div class="form-group col-md-5">
                                        <label class="">{{trans('home.online_url')}}</label>
                                        <input class="form-control @error('online_url') is-invalid @enderror" name="online_url" value="{{$partner_request->address ?? ''}}" disabled type="text" placeholder="{{trans('home.online_url')}}">
                                    </div>
        
                                    
                                    <div class="form-group col-md-3">
                                        @error('center_id') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                        <label class="">{{trans('home.partner')}}</label>
                                        <select class="form-control select2 centers" required name="center_id" id="" disabled >
                                            <option value="">{{ $partner_request->center->{'name_'.$lang} ?? ''}}</option>
                                        </select>
                                    </div>
            
                                    
                                    <div class="form-group col-md-3">
                                        <label for="centers">{{trans('home.instructor')}}</label>
                                        <select class="form-control select2 instructors" name="instructor_id" disabled>
                                           <option value="">{{ $partner_request->instructor->f_name ?? ''}}</option>
                                        </select>
                                    </div>
                             
                                    
                                    <div class="form-group col-md-3">
                                        <label for="centers">{{trans('home.center_halls')}}</label>
                                        <select class="form-control select2 halls" name="hall_id" disabled>
                                            <option value="">{{ $partner_request->hall->{'name_'.$lang} ?? ''}}</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group col-md-3">
                                        <label for="start_date">{{trans('home.start_date')}}</label>
                                        <div class="input-group">
                                            <input type='date' class="form-control datepicker" name="start_date" value="{{$partner_request->start_date ?? ''}}" disabled placeholder="{{trans('home.start_date')}}"  required/>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group col-md-3">
                                        <label for="end_date">{{trans('home.end_date')}}</label>
                                        <div class="input-group">
                                            <input type='date' class="form-control datepicker" name="end_date" value="{{$partner_request->end_date ?? ''}}" disabled placeholder="{{trans('home.end_date')}}" required/>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label for="training_field_id">{{trans('home.training_field_id')}}</label>
                                        <select class="form-control select2 col-12" name="training_field_id" disabled>
                                            <option value="">{{ $partner_request->field->{'name_'.$lang} ?? ''}}</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group col-md-3">
                                        <label for="timing_type">{{trans('home.timing_type')}}</label>
                                        <select class="form-control select2" name="timing_type" disabled>
                                            <option @selected($partner_request->timing_type == 'AM') value="AM">{{trans('home.AM')}}</option>
                                            <option @selected($partner_request->timing_type == 'PM') value="PM">{{trans('home.PM')}}</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label for="recorded">{{trans('home.recorded')}}</label>
                                        <select class="form-control select2" name="recorded" disabled>
                                            <option @selected($partner_request->recorded == 'yes') value="yes">{{trans('home.yes')}}</option>
                                            <option @selected($partner_request->recorded == 'no') value="no">{{trans('home.no')}}</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group col-md-3">
                                        <label for="time_from">{{trans('home.time_from')}} ({{trans('home.attendance')}})</label>
                                        <div class="input-group"> 
                                            <input type='time' class="form-control timepicker" name="time_from" value="{{$partner_request->time_from ?? ''}}" disabled placeholder="{{trans('home.time_from')}}"  required/>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group col-md-3">
                                        <label for="time_to">{{trans('home.time_to')}} ({{trans('home.attendance')}})</label>
                                        <div class="input-group">
                                            <input type='time' class="form-control timepicker" name="time_to" value="{{$partner_request->time_to ?? ''}}" disabled placeholder="{{trans('home.time_to')}}"  required/>
                                        </div>
                                    </div>
        
                                    <div class="form-group col-md-2">
                                        <label class="">{{trans('home.overall_days')}}</label>
                                        <input class="form-control" name="overall_days" value="{{$partner_request->overall_days ?? ''}}" disabled type="number" min="0" placeholder="{{trans('home.overall_days')}}" required/>
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label class="">{{trans('home.overall_time')}}</label>
                                        <input class="form-control" name="overall_time" value="{{$partner_request->overall_time ?? ''}}" disabled type="number" min="0" placeholder="{{trans('home.overall_time')}}" required/>
                                    </div>
                                   
                                    <div class="form-group col-md-4">
                                        <label for="helperText">{{trans('home.courses')}} </label>
                                        <select class="form-control role select2" name="courses_id[]" multiple disabled>
                                            @if(isset($partner_request->course_ids))
                                                @foreach(array($partner_request->course_ids) as $course_id)
                                                    @php
                                                        $course = App\Models\Course::find($course_id);
                                                    @endphp
                                                    <option value="" >{{(app()->getLocale() == 'en')?$course->name_en ?? '':$course->name_ar ?? '' }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                        </div>
              </div>
              <div class="modal-footer  justify-content-center ">
                <button id="closeModalButton" type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
              </div>
            </form>
            </div>
          
          </div>
    </div>
            --}}
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')



<script>
    $(document).ready(function(){
        $('#btn_delivered_partner').click(function(){
            var id = [];
            var status = 'delivered';
            $('.tableChecked:checked').each(function(i){
                id[i] = $(this).val();
            });
            
            if(id.length === 0) //tell you if the array is empty
            {
                alert("Please Select at least one checkbox");
            }
            
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"<?php echo url('admin/partners_training_requests_change_status')?>", 
                method:'POST',
                data:{id:id,status:status},
                success:function(data)
                {
                    location.reload();
                }
            });
        });
        
        $('#btn_processing_partner').click(function(){
            var id = [];
            var status = 'processing';
            $('.tableChecked:checked').each(function(i){
                id[i] = $(this).val();
            });
            
            if(id.length === 0) //tell you if the array is empty
            {
                alert("Please Select at least one checkbox");
            }
            
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"<?php echo url('admin/partners_training_requests_change_status')?>", 
                method:'POST',
                data:{id:id,status:status},
                success:function(data)
                {
                    location.reload();
                }
            });
        });
        
        $('#btn_accepted_partner').click(function(){
            var training_code5 = $('#training_code5').val();
            var training_code3 = $('#training_code3').val();
            var status = 'accepted';
            var id = [];
            $('.tableChecked:checked').each(function(i){
                id[i] = $(this).val();
                if($(this).data('request_type') != 'new') {
                    alert("Please Select only new requests");
                }
            });
            
            if(id.length === 0) //tell you if the array is empty
            {
                alert("Please Select at least one checkbox");
            }
            if(id.length != 0 && training_code5.length===0 && training_code3.length===0){
                alert("Please Training Code");
            }
            else
            {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo url('admin/partners_training_requests_change_status')?>", 
                    method:'POST',
                    data:{id:id,status:status,training_code5:training_code5,training_code3:training_code3},
                    success:function(data)
                    {
                        location.reload();
                    }
                });
            }
        });
        $('#btn_edited_partner').click(function(){
            var status = 'edited';
            var id = [];
            $('.tableChecked:checked').each(function(i){
                id[i] = $(this).val();
                if($(this).data('request_type') != 'edit' && $(this).data('request_type') != 'exception') {
                    alert("Please Select only edit or exception requests");
                }
            });
            
            if(id.length === 0) //tell you if the array is empty
            {
                alert("Please Select at least one checkbox");
            }
            else
            {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo url('admin/partners_training_edit_requests_change_status')?>", 
                    method:'POST',
                    data:{id:id,status:status},
                    success:function(data)
                    {
                        location.reload();
                    }
                });
            }
        });
    });
</script>
<!--show detaisl-->
    <script>
        $(document).on('click', '.show_detials', function() {
            var partner_request_id = $(this).data('partner_request_id');
            var modalId = '#partner_request_modal_' + partner_request_id;
            // var fieldHTML ='<span class="badge badge-info">{{__('home.seen')}}</span>';
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                 url:"{{ route('partner_training_request_details') }}",
                method: 'Post',
                data: {
                    partner_request_id:partner_request_id},
                success: function (data) {
                    $('body').append(data.view);
                    // $('#status_'+partner_request_id).html(fieldHTML);
                    $(modalId).modal('show');
                },
            });
        });
    </script>

@endsection