<div class="modal fade bd-example-modal-lg" id="partner_request_modal_{{$partner_request->id}}" style="z-index:99999"  tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
    <div class="modal-content" style="border-radius: 35px;">
      <div class="modal-header">
        <h5 class="modal-title m-auto" id="exampleModalLongTitle">  {{$partner_request->{'name_'.$lang} }}</h5>
        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form method="post" action="{{ route('edit_partners_training_request') }}" enctype="multipart/form-data">
          @csrf
      <div class="modal-body">
             <div class="modal-body ">
                <input class="form-control" name="id" type="hidden" value="{{ $partner_request->id ?? '' }}" >
                <div class="row">
                    <div class="form-group col-md-3">
                        <label class="">{{trans('home.name_en')}}</label>
                        <input class="form-control" name="name_en" type="text" value="{{ $partner_request->name_en ?? '' }}" placeholder="{{trans('home.name_en')}}" >
                    </div>
                    <div class="form-group col-md-3">
                        <label class="">{{trans('home.name_ar')}}</label>
                        <input class="form-control" name="name_ar" type="text" value="{{ $partner_request->name_ar ?? '' }}" placeholder="{{trans('home.name_ar')}}" >
                    </div>
                    <div class="form-group col-md-3">
                        <label class="">{{trans('home.n_students')}}</label>
                        <input class="form-control" name="n_students" type="number" value="{{ $partner_request->n_students ?? '' }}" placeholder="{{trans('home.n_students')}}" >
                    </div>
                    <div class="form-group col-md-3">
                        <label for="training_type">{{trans('home.training_type')}}</label>
                        <select class="form-control select2" name="training_type" >
                            <option value="">{{trans('home.choose_type')}}</option>
                            <option @selected($partner_request->training_type == 'online') value="online">{{trans('home.online')}}</option>
                            <option @selected($partner_request->training_type == 'offline') value="offline">{{trans('home.offline')}}</option>
                        </select>
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label class="">{{trans('home.address')}}</label>
                        <input class="form-control" name="address" type="text" value="{{ $partner_request->address ?? '' }}" placeholder="{{trans('home.address')}}" >
                    </div>
                    <div class="form-group col-md-3">
                        <label class="">{{trans('home.online_url')}}</label>
                        <input class="form-control" name="online_url" type="text" value="{{ $partner_request->online_url ?? '' }}" placeholder="{{trans('home.online_url')}}" >
                    </div>
                    
                  {{--  @if($partner_request->image)
                        <div class="col-md-3">
                            <label>{{trans('home.image')}}</label>
                                <img src={{url('uploads/trainings/'.$partner_request->image)}} width="100">
                        </div>
                    @endif
                    <div class="form-group col-md-2">
                        <label class="">{{trans('home.alt_img')}}</label>
                        <input class="form-control" name="alt_img" type="text" value="{{ $partner_request->alt_img ?? '' }}" placeholder="{{trans('home.alt_img')}}" disabled>
                    </div> 
                    --}}
                    
                    <div class="form-group col-md-3">
                        @error('center_id') <p class="alert alert-danger">{{ $message }}</p> @enderror
                        <label class="">{{trans('home.partner')}}</label>
                            <select class="form-control select2 centers"  name="center_id" id="" >
                            <option value="">{{ __('home.choose_center') }}</option>
                            @foreach ($centers as $center)
                                <option value ="{{$center->id}}" @selected($partner_request->center->id == $center->id)>{{(app()->getLocale()=='en')? $center->name_en:$center->name_ar}}</option>
                            @endforeach
                        </select>
                    </div>
                  
                    <div class="form-group col-md-3">
                        <label for="instructors">{{trans('home.instructor')}}</label>
                        <select class="form-control select2 instructors" name="instructor_id" >
                            <option value="">{{ __('home.choose_instructor') }}</option>
                            @foreach($instructors as $instructor)
                                <option value="{{$instructor->id}}" @if($partner_request->instructor) @selected($partner_request->instructor->id == $instructor->id) @endif >{{$instructor->f_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label for="request_type">{{trans('home.request_type')}}</label>
                        <select class="form-control select2" name="request_type" id="request_type" readonly required>
                            <option value="{{$partner_request->request_type}}">{{$partner_request->request_type == 'edit' ? trans('home.edit_request') : trans('home.new_request')}}</option>
                            {{--<option @selected($partner_request->request_type == 'edit') value="edit">{{trans('home.edit_request')}}</option>--}}
                        </select>
                    </div>
                    
                    @if($partner_request->code_to_edit)
                        <div class="form-group col-md-3" id="code_to_edit">
                            <label class="">{{trans('home.code_to_edit')}}</label>
                            <input class="form-control @error('code_to_edit') is-invalid @enderror" value="{{old('code_to_edit',$partner_request->code_to_edit)}}" name="code_to_edit" type="text" readonly placeholder="{{trans('home.code_to_edit')}}">
                        </div>
                    @endif
                              
                    <div class="form-group col-md-3">
                        <label for="centers">{{trans('home.center_halls')}}</label>
                        <select class="form-control select2 halls" name="hall_id" >
                            <option value="">{{ trans('home.choose_hall') }}</option>
                            @foreach($halls as $hall)
                                <option value="{{$hall->id}}" @if($partner_request->hall) @selected($partner_request->hall->id == $hall->id) @endif >{{(app()->getLocale() == 'en')?$hall->name_en:$hall->name_ar }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label for="start_date">{{trans('home.start_date')}}</label>
                        <div class="input-group">
                            <input type='date' class="form-control datepicker" name="start_date" placeholder="{{trans('home.start_date')}}"  value="{{old('start_date',$partner_request->start_date)}}"/>
                        </div>
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label for="end_date">{{trans('home.end_date')}}</label>
                        <div class="input-group">
                            <input type='date' class="form-control datepicker" name="end_date" placeholder="{{trans('home.end_date')}}"  value="{{old('end_date',$partner_request->end_date)}}"/>
                        </div>
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label for="training_field_id">{{trans('home.training_field_id')}}</label>
                        <select class="form-control select2 col-12" name="training_field_id" >
                            <option value="">{{ trans('home.choose_field') }}</option>
                            @foreach($fields as $field)
                                <option value="{{$field->id}}" @selected($partner_request->field->id == $field->id) >{{(app()->getLocale() == 'en')?$field->name_en:$field->name_ar }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label for="timing_type">{{trans('home.timing_type')}}</label>
                        <select class="form-control select2" name="timing_type">
                            <option value="">{{ trans('home.choose_type') }}</option>
                            <option @selected($partner_request->timing_type == 'AM') value="AM">{{trans('home.AM')}}</option>
                            <option @selected($partner_request->timing_type == 'PM') value="PM">{{trans('home.PM')}}</option>
                        </select>
                    </div>

                    <div class="form-group col-md-3">
                        <label for="recorded">{{trans('home.recorded')}}</label>
                        <select class="form-control select2" name="recorded" required>
                            <option value="">{{ trans('home.choose_type') }}</option>
                            <option @selected($partner_request->recorded == 1) value="yes">{{trans('home.yes')}}</option>
                            <option @selected($partner_request->recorded == 0) value="no">{{trans('home.no')}}</option>
                        </select>
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label for="time_from">{{trans('home.time_from')}} ({{trans('home.time_from')}})</label>
                        <div class="input-group">
                            <input type='time' class="form-control timepicker" name="time_from" placeholder="{{trans('home.time_from')}}" value="{{old('time_from',$partner_request->time_from)}}"/>
                        </div>
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label for="time_to">{{trans('home.time_to')}} ({{trans('home.time_to')}})</label>
                        <div class="input-group">
                            <input type='time' class="form-control timepicker" name="time_to" placeholder="{{trans('home.time_to')}}" value="{{old('time_to',$partner_request->time_to)}}"/>
                        </div>
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label class="">{{trans('home.overall_days')}}</label>
                        <input class="form-control" name="overall_days" type="number" value="{{ $partner_request->overall_days}}" min="0" placeholder="{{trans('home.overall_days')}}" />
                    </div>
                    
                    <div class="form-group col-md-3">
                        <label class="">{{trans('home.overall_time')}}</label>
                        <input class="form-control" name="overall_time" type="number" min="0" value="{{ $partner_request->overall_time}}" placeholder="{{trans('home.overall_time')}}" />
                    </div>
                    
                    {{--<div class="form-group col-md-2">
                        <label class="">{{trans('home.view_survey_date')}}</label>
                        <input class="form-control" name="view_survey" type="text" value="{{ $partner_request->view_survey}}" placeholder="{{trans('home.view_survey_date')}}" >
                    </div>
                    <div class="form-group col-md-2">
                        <label class="">{{trans('home.view_exam_date')}}</label>
                        <input class="form-control" name="view_exam" type="text" value="{{ $partner_request->view_exam}}" placeholder="{{trans('home.view_exam_date')}}" >
                    </div> 
                    
                    <div class="form-group col-md-6">
                        <label for="helperText">{{trans('home.courses')}}  </label>
                        <select class="form-control role select2" name="courses_id[]">
                            @foreach($courses as $course)
                                @if($partner_request->course_ids != "null" && $partner_request->course_ids != null)
                                    @if(in_array($course->id, json_decode($partner_request->course_ids)))
                                        <option value="{{$course->id}}" selected >{{$course->{'name_'.$lang} }}</option>
                                    @endif
                                @endif
                            @endforeach
                        </select>
                    </div>--}}
                    
            </div>
              </div>
      </div>
      
      <div class="modal-footer  justify-content-center ">
           <button class="btn ripple btn-primary " type="submit"><i
                        class="fas fa-edit"></i>
                        {{ trans('home.edit') }}</button>
        <button id="closeModalButton" type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
      </div>
      </form>
              
    </div>
  </div>
</div>


<script>
    $('#request_type').on('change',function () {
        if ($(this).val() === 'edit') {
            $('#code_to_edit').show();
        }else {
            $('#code_to_edit').hide();
        }
    });
</script>