@extends('layouts.admin')
<title>{{ trans('home.marketing_program_requests') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.marketing_program_requests') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.marketing_program_requests') }}</li>
                </ol>
            </div>

            {{-- @can('wad_requests_operations')
                <div class="btn btn-list">
                    @can('wad_requests_accept_button')
                        <a id="btn_active_marketing_program"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                                {{ trans('home.accept') }}</button>
                        </a>
                    @endcan
                    @can('wad_requests_delete_button')
                        <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                                {{ trans('home.delete') }}</button></a>
                    @endcan
                </div>
            @endcan --}}
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        
        
        
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.job_seekers_statistics')}}</h6>
                            <br>
                        </div>
                        
                            <div class="row d-flex justify-content-start">
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-success-transparent rounded-circle text-success">
        									    <i class="far fa-registered"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.registered_count')}}</p>
        									<h3 class="mb-0">{{$registered_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-primary-transparent rounded-circle text-primary">
        									    <i class="fas fa-building"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.gada_count')}}</p>
        									<h3 class="mb-0">{{$gada_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-info-transparent rounded-circle text-info">
        										<i class="fas fa-city"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.riyadh_count')}}</p>
        									<h3 class="mb-0">{{$riyadh_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-secondary-transparent rounded-circle text-secondary">
        										<i class="fas fa-building"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.other_region_count')}}</p>
        									<h3 class="mb-0">{{$other_region_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-danger-transparent rounded-circle text-danger">
        										<i class="fas fa-male"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.male_count')}}</p>
        									<h3 class="mb-0">{{$male_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-success-transparent rounded-circle text-success">
        										<i class="fas fa-female"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.female_count')}}</p>
        									<h3 class="mb-0">{{$female_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-primary-transparent rounded-circle text-primary">
        										<i class="fas fa-university"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.university_count')}}</p>
        									<h3 class="mb-0">{{$university_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-info-transparent rounded-circle text-info">
        										<i class="fas fa-graduation-cap"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.diploma_count')}}</p>
        									<h3 class="mb-0">{{$diploma_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-secondary-transparent rounded-circle text-secondary">
        										<i class="fas fa-award"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.secondary_count')}}</p>
        									<h3 class="mb-0">{{$secondary_count}}</h3>
        								</div>
        							</div>
        						</div>
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-danger-transparent rounded-circle text-danger">
        										<i class="fas fa-medal"></i>
        									</div>
        									<p class="mb-1 text-muted">{{trans('home.intermediate_count')}}</p>
        									<h3 class="mb-0">{{$intermediate_count}}</h3>
        								</div>
        							</div>
        						</div>
        					</div>
					
                        </div>
                    </div>
                </div>
            </div>
        
        

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.marketing_program_requests') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>
                        <div class="table-responsive">
                            
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <!--<th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>-->
                                        <th>{{ trans('home.id') }}</th>
                                        <th class="wd-100p" >{{ trans('home.name') }}</th>
                                        <th class="wd-50p">{{ trans('home.email') }}</th>
                                        <th class="wd-10p">{{ trans('home.phone') }}</th>
                                        <th class="wd-10p">{{ trans('home.location') }}</th>
                                        <!--<th class="wd-10p">{{ trans('home.region') }}</th>-->
                                        <th class="wd-10p">{{ trans('home.age') }}</th>
                                        <!--<th class="wd-100p">{{ trans('home.nationality') }}</th>-->
                                        <th class="wd-10p">{{ trans('home.gender') }}</th>
                                        <th class="wd-10p">{{ trans('home.qualification') }}</th>
                                        <th class="wd-10p">{{ trans('home.specialization') }}</th>
                                        <th class="wd-10p">{{ trans('home.insurance_status') }}</th>
                                        <th class="wd-10p">{{ trans('home.created_at') }}</th>
                                        <th class="wd-10p">{{ trans('home.request_status') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($marketing_program_requests as $marketing_program_request)
                                        <tr id="{{ $marketing_program_request->id }}">
                                            <!--<td> <input type="checkbox" name="checkbox" class="tableChecked" value="{{ $marketing_program_request->id }}" /> </td>-->
                                            <td><a href="javascript::void(0)">{{ $marketing_program_request->id }}</a>  </td>
                                            <td class="w-100"><a href="javascript::void(0)">{{ $marketing_program_request->full_name }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ $marketing_program_request->email }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ $marketing_program_request->phone }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ trans('home.'.$marketing_program_request->location) }}</a>  </td>
                                            <!--<td><a href="javascript::void(0)">{{ $marketing_program_request->region }}</a>  </td>-->
                                            <td><a href="javascript::void(0)">{{ $marketing_program_request->age }}</a>  </td>
                                            <!--<td><a href="javascript::void(0)">{{ $marketing_program_request->nationality }}</a>  </td>-->
                                            <td><a href="javascript::void(0)">{{ trans('home.'.$marketing_program_request->gender) }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ __('home.'.$marketing_program_request->qualification) }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ $marketing_program_request->specialization }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ trans('home.'.$marketing_program_request->insurance_status) }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ $marketing_program_request->created_at }}</a>  </td>
                                            <td><a  href="javascript::void(0)">{{ $marketing_program_request->admin_seen==1? __('home.seen') : __('home.not_seen') }}</a> </td>
                                        </tr>
                                    @endforeach
                                </tbody>    
                            </table>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
<script>
    $(document).ready(function(){
        $('#btn_active_marketing_program').click(function(){
            var id = [];
            $('.tableChecked:checked').each(function(i){
                id[i] = $(this).val();
            });
            
            if(id.length === 0) //tell you if the array is empty
            {
                alert("Please Select at least one checkbox");
            }
            else
            {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo url('admin/marketing_program_requests_change_status')?>", 
                    method:'POST',
                    data:{id:id},
                    success:function(data)
                    {
                        // console.log(data);
                        location.reload();
                    }
                });
            }
        });
    });
</script>
    

@endsection