@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.partner') }}</title>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.partner_centers') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('partners.index') }}">{{ trans('home.partners') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.partner_centers') }}</li>
                </ol>
            </div>
            <div class="btn btn-list">
                @can('partners_centers_delete_button')
                    <a class="mr-2" id="delete_btn"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                                {{ trans('home.delete') }}</button></a>
                @endcan
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="text-center">
                            <h5> {{__('home.partner')}} </h5> 
                        </div>
                        <div class="text-center">
                            <h1> {{$user->name() }} </h1> 
                        </div>
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.partner_centers') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="checkAll"/></th>
                                        <th>{{trans('home.id')}}</th>
                                        <th class="wd-20p">{{trans('home.name')}}</th>
                                        <th class="wd-15p">{{trans('home.description')}}</th>
                                        <th >{{trans('home.partner')}}</th>
                                        <th >{{trans('home.responsible_name')}}</th>
                                        <th >{{trans('home.responsible_phone')}}</th>
                                        <th  class="wd-15p">{{trans('home.logo')}}</th>
                                        <th >{{trans('home.status')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($user->partner as $partner)
                                        @foreach ($partner->centers as $center)
                                            <tr id="{{$center->id}}">
                                                <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$center->id}}" /> </td>
                                                <td><a href="{{ route('centers.edit', $center->id) }}">{{$center->id}}</a></td>
                                                <td><a href="{{ route('centers.edit', $center->id) }}">{{(app()->getLocale() == 'en')?$center->name_en:$center->name_ar}}</a></td>
                                                <td><a href="{{ route('centers.edit', $center->id) }}">
                                                    {{strip_tags(mb_strimwidth($center->{'text_'.$lang}, 0, 100, "..."))}}</a>
                                                </td>
                                                <td><a href="{{ route('centers.edit', $center->id) }}">
                                                    {{$center->partner?$center->partner->user->f_name:'Super Admin'}}</a></td>
                                                <td><a href="{{ route('centers.edit', $center->id) }}">{{$center->responsible_name}}</a></td>
        
                                                <td><a href="{{ route('centers.edit', $center->id) }}">{{$center->responsible_phone}}</a></td>
                                                <td><a href="{{ route('centers.edit', $center->id) }}">
                                                    <img style="height:80px;" src="{{ url("uploads/centers/$center->logo") }}" alt=""></a></td>
                                                <td>
                                                    <a href="{{ route('centers.edit', $center->id) }}">
                                                        @if($center->status == 1)
                                                            <span class="badge badge-success">{{trans('home.yes')}}</span>
                                                        @else
                                                            <span class="badge badge-danger">{{trans('home.no')}}</span>
                                                        @endif
                                                    </a>
                                                </td>  
                                            </tr>
                                        @endforeach
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <a href="{{ route('partners.index') }}">
                                    <button type="button"class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                        {{ trans('home.back') }}</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

    </div>
@endsection

@section('script')
    <script>
        $(document).ready(function(){
                $('#delete_btn').click(function(){
                    var id = [];
                    <?php
                    $route = url('partners-centers-delete');
                    ?>
                    $('.tableChecked:checked').each(function(i){
                        id[i] = $(this).val();
                    });
                    if(id.length === 0) //tell you if the array is empty
                    {
                        alert("Please Select atleast one checkbox");
                    }
                    else
                    {
                        $.confirm({
                            title: '{{__('home.Are you sure you want to delete that ?')}}',
                            content:'',
                            buttons: {
                                confirm: {
                                    text: '{{__('home.delete')}}',
                                    btnClass: 'btn-red any-other-class',
                                    keys: ['enter', 'shift'],
                                    action: function(){
                                         $.ajaxSetup({
                                            headers: {
                                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                            }
                                        });
                        
                                        $.ajax({
                                            url: "<?php echo url('/admin/partners-centers-delete') ?>/" + id,
                                            type: 'DELETE',
                                            data: {id: id},
                                            success: function () {
                                                for (var i = 0; i < id.length; i++) {
                                                    $('tr#' + id[i]).css('background-color', '#ccc').fadeOut('slow');
                                                    $('input:checkbox[value="' + id[i] + '"]').removeClass('tableChecked').removeAttr('checked');
                                                }
                                            }
                                        }); 
                                    }
                                },
                                cancel: {
                                    text: '{{__('home.cancel')}}',
                                    action: function(){
                                        close();
                                    }
                                }
                            }
                        });
                    }
                });
            });
        </script>
@endsection

