@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_partner')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.partners')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('partners.index')}}">{{trans('home.partners')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_partner')}}</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
        <div class="card custom-card overflow-hidden">
            <div class="card-body">
                <!-- End Page Header -->
                {!! Form::open(['route' => 'assign_partner_to_center_action', 'data-toggle'=>'validator']) !!}
                    <!-- Row-->
                    @csrf
                    <div class="row">
                        <div class="form-group col-md-4">
                            <label for="course">{{trans('home.partner')}}</label>
                            <select class="form-control select2 @error('user') is-invalid @enderror" name="user">
                                @foreach($users as $user)
                                    <option value="{{$user->id}}">{{$user->f_name.' '.$user->l_name }}</option>
                                @endforeach    
                            </select>
                            @error('user')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-md-4">
                            <label for="course">{{trans('home.centers')}}</label>
                            <select class="form-control select2 @error('center') is-invalid @enderror" name="center">
                                @foreach($centers as $center)
                                    <option value="{{$center->id}}">{{$center->{'name_'.$lang} }}</option>
                                @endforeach    
                            </select>
                            @error('center')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                         <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                            <a href="{{route('partners.index')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                        </div>
                    </div>
                    <!-- End Row -->
                {!! Form::close() !!}
            </div>
        </div>
    </div>
    </div>
</div>

@endsection

