@extends('layouts.admin')
<title>{{trans('home.messages')}}</title>

@section('style')
     <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">
@endsection

@section('content')

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.messages')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.messages')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <h6 class="card-title mb-1">{{trans('home.messages')}}</h6>
                        <hr>
                        
                        <div class="row">
                            <div class="form-group col-md-4">
                                <label for="trainings">{{trans('home.trainings')}}</label>
                                <select class="form-control select2" name="training_id" id="trainings" required>
                                    <option>{{trans('home.choose_training')}}</option>
                                    {{--<option value="all">{{trans('home.all')}}</option>--}}
                                    @foreach($trainings as $training)
                                        <option value="{{$training->id}}">{{(app()->getLocale() == 'en')?$training->name_en . ' - ' . $training->code:$training->name_ar . ' - ' . $training->code}}</option>
                                    @endforeach
                                </select>
                            </div> 
                        
                            <div class="form-group col-md-4">
                                <label for="method">{{trans('home.send_method')}}</label>
                                <select class="form-control select2" name="method" id="method" required>
                                    <option>{{trans('home.choose_send_method')}}</option>
                                    <option value="email">{{trans('home.email')}}</option>
                                    <option value="whatsapp">{{trans('home.whatsapp')}}</option>
                                    <option value="sms">{{trans('home.sms')}}</option>
                                </select>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <label class="">{{trans('home.message')}}</label>
                                <textarea class="form-control area1 @error('message') is-invalid @enderror" name="message" type="text" id="message" required placeholder="{{trans('home.message')}}">{{ old('message') }}</textarea>
                                @error('message')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <button id="send_btn" class="btn btn-success">{{trans('home.send')}}</button>
                            </div>
                            
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        <div class="statisticsResult">
                                
        </div>
        
        <div class="searchResult">
                                
        </div>
    </div>

@endsection

@section('script')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.all.min.js"></script>

@if(session()->has('error'))
    <script>
        Swal.fire({
            icon: 'danger',
            title: '{{ session()->pull("error") }}',
        });
    </script>
@endif

<script>
    
    $('#send_btn').on('click',function(){
        var trainingId = $('#trainings option:selected').val();
        var method = $('#method').val();
        var message = $('#message').val();

        if(method == 'whatsapp'){
            if(trainingId && method && message){
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
            
                    $.ajax({
                        url:" {{url('admin/send-whatsapp-messages')}}",
                        method:'POST',
                        data:{trainingId:trainingId,method:method,message:message},
                        beforeSend: function() {
                            Swal.fire({
                                icon: 'success',
                                title: '{{__("home.messages_has_sent")}}',
                            });
                        },
                        success:function(html)
                        {
                            // $('#filter-loading').hide();
                        }
                    });
            }else{
                alert("{{trans('home.Please Select Data')}}");
            }
        } else if(method == 'sms') {
            if(trainingId && method && message){
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
            
                    $.ajax({
                        url:" {{url('admin/send-sms-messages')}}",
                        method:'POST',
                        data:{trainingId:trainingId,message:message},
                        beforeSend: function() {
                            Swal.fire({
                                icon: 'success',
                                title: '{{__("home.messages_has_sent")}}',
                            });
                        },
                        success:function(html)
                        {
                            // $('#filter-loading').hide();
                        }
                    });
            }else{
                alert("{{trans('home.Please Select Data')}}");
            }
        } else if(method == 'email') {
            if(trainingId && method && message){
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
            
                    $.ajax({
                        url:" {{url('admin/send-emails')}}",
                        method:'POST',
                        data:{trainingId:trainingId,message:message},
                        beforeSend: function() {
                            Swal.fire({
                                icon: 'success',
                                title: '{{__("home.emails_has_sent")}}',
                            });
                        },
                        success:function(html)
                        {
                            // $('#filter-loading').hide();
                        }
                    });
            }else{
                alert("{{trans('home.Please Select Data')}}");
            }
        }

     
    });
    
</script>
@endsection