@extends('layouts.admin')
<title>{{ trans('home.lessons') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.lessons') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.lessons') }}</li>
                </ol>
            </div>

            <div class="btn btn-list">

                <a href="{{ route('lessons.create') }}"><button class="btn ripple btn-primary"><i
                            class="fas fa-plus-circle"></i> {{ trans('home.add') }}</button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                        {{ trans('home.publish/unpublish') }}</button></a>
                <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                        {{ trans('home.delete') }}</button></a>
            </div>
        </div>


        @if (session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session()->pull('success') }} <button type="button" class="btn-close" data-bs-dismiss="alert"
                    aria-label="Close"></button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card-body">
                    <table class="table text-center" id="exportexample">
                        <thead>
                            <tr>
                                <th><input type="checkbox" class="form-check-input" id="checkAll" /></th>
                                <th>{{ trans('home.id') }}</th>
                                <th>{{ trans('home.name') }}</th>
                                <th>{{ trans('home.course') }}</th>
                                <th>{{ trans('home.chapter') }}</th>
                                <th>{{ trans('home.n') .' - '. __('home.attachments') }}</th>
                                <th>{{ trans('home.order') }}</th>
                                <th>{{ __('home.publish/unpublish') }}</th>
                                <th>{{ __('home.edit') }}</th>
                                <th>{{ __('home.delete') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($lessons as $lesson)
                                <tr id="{{ $lesson->id }}">
                                    <td> <input type="checkbox" name="checkbox" class="tableChecked form-check-input"
                                            value="{{ $lesson->id }}" /> </td>
                                    <td><a href="{{ route('lessons.edit', $lesson->id) }}">{{ $lesson->id }}</a></td>
                                    <td>{{ $lesson->{'name_' . $lang} }}</td>
                                    <td>
                                        <a href="{{ $lesson->course ? route('courses.edit', $lesson->course->id) : '' }}">
                                            {{ $lesson->course ? $lesson->course->{'name_' . $lang} : 'N/A' }}
                                        </a>
                                    </td>
                                    <td>
                                        <a
                                            href="{{ $lesson->chapter ? route('lessons.edit', $lesson->chapter->id) : '' }}">
                                            {{ $lesson->chapter ? $lesson->chapter->{'name_' . $lang} : 'N/A' }}
                                        </a>
                                    </td>
                                    <td>
                                        {{count($lesson->attachments)}}
                                    </td>
                                    <td>
                                        {{$lesson->order}}
                                    </td>
                                    <td>
                                        <input class="btn_active" data-id="{{ $lesson->id }}" type="checkbox"
                                            id="switch-{{ $lesson->id }}" switch="success"
                                            {{ $lesson->status == 1 ? 'checked' : '' }} />
                                        <label for="switch-{{ $lesson->id }}" data-on-label="{{ trans('home.yes') }}"
                                            data-off-label="{{ trans('home.no') }}"></label>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-info waves-effect waves-light "
                                            href="{{ route('lessons.edit', $lesson->id) }}">{{ __('home.edit') }}</a>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-danger waves-effect waves-light btn_delete"
                                            data-id="{{ $lesson->id }}">{{ __('home.delete') }}</a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
