@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_lesson')}}</title>
@endsection
@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.lessons')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('lessons.index')}}">{{trans('home.lessons')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_lesson')}}</li>
            </ol>
        </div>
    </div>

        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['route' => 'lessons.store', 'data-toggle' => 'validator', 'files' => 'true']) !!}
                                    <div class="row">

                                        <div class="col-md-2 mb-3">
                                            <label for="name_en">{{ trans('home.name_en') }}</label>
                                            <input type="text" class="form-control" placeholder="{{ trans('home.name_en') }}"
                                                name="name_en" required>
                                        </div>
                                        <div class="col-md-2 mb-3">
                                            <label for="name_ar">{{ trans('home.name_ar') }}</label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ trans('home.name_ar') }}" name="name_ar" required>
                                        </div>
                                        <div class="col-md-2 mb-3">
                                            <label for="order">{{ trans('home.order') }}</label>
                                            <input type="number" class="form-control" 
                                                placeholder="{{ trans('home.order') }}" name="order">
                                        </div>
                                        


                                        <div class="col-md-3 mb-3">
                                            <label for="level_id">{{ trans('home.course') }}</label>
                                            <span
                                                class="text-danger selectCourse">{{ __('home.Please, Select course first') }}</span>
                                            <select class="form-control" id="course_id" data-trigger name="course_id">
                                                <option value="" selected disabled>{{ __('Select a course') }}</option>
                                                @foreach ($courses as $course)
                                                    <option value="{{ $course->id }}">
                                                        {{ $course->{'name_' . $lang} }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div id="course_type" class="col-md-3 mb-3"></div>

                                        <div class="col-md-12 mb-3" id="content_link">
                                            <label for="content_link">{{ trans('home.meeting_Link_ar') }}</label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ trans('home.meeting_Link_ar') }}" name="content_link_ar" required>
                                        </div>
                                        
                                        <div class="col-md-12 mb-3" id="content_link">
                                            <label for="content_link">{{ trans('home.meeting_Link_en') }}</label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ trans('home.meeting_Link_en') }}" name="content_link_en" required>
                                        </div>
                                        
                                        <div class="col-md-3 mb-3">
                                            <label for="chapter_id">{{ trans('home.chapter') }}</label>
                                            <select class="form-control" required id="chapter_id" name="chapter_id">
                                            </select>
                                        </div>


                                        <div class="col-md-3 mb-3 d-none" id="meeting_date">
                                            <label for="meeting_date">{{ trans('home.meeting_date') }}</label>
                                            <input type="date" class="form-control"
                                                placeholder="{{ trans('home.meeting_date') }}" name="meeting_date">
                                        </div>
                                        <div class="col-md-2 mb-3 d-none" id="meeting_time">
                                            <label for="meeting_time">{{ trans('home.meeting_time') }}</label>
                                            <input type="time" class="form-control"
                                                placeholder="{{ trans('home.meeting_time') }}" name="meeting_time">
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <label for="duration">{{ trans('home.duration') }}</label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ trans('home.duration') }}" name="duration" required>
                                        </div>

                                        <div class="col-md-12 row">
                                            <div class="col-md-6 mb-3 ">
                                                <label for="text_en">{{ trans('home.text_en') }}</label>
                                                <textarea class="form-control ckeditor-classic" placeholder="{{ trans('home.text_en') }}" name="text_en"></textarea>
                                            </div>
                                            <div class="col-md-6 mb-3 ">
                                                <label for="text_ar">{{ trans('home.text_ar') }}</label>
                                                <textarea class="form-control ckeditor-classic" placeholder="{{ trans('home.text_ar') }}" name="text_ar"></textarea>
                                            </div>
                                        </div>

                                        <h4 class="card-title mt-3 mb-3">{{ trans('home.seo_block') }}</h4>
                                        <div class="form-group col-md-6">
                                            <span class="badge-soft-primary">{{ trans('home.en') }}</span>
                                            <div class="col-md-12 mb-3">
                                                <label for="link_en">{{ trans('home.slug') }}</label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ trans('home.slug') . ' ' . __('home.en') }}"
                                                    name="link_en">
                                            </div>
                                        </div>


                                        <div class="form-group col-md-6">
                                            <span class="badge-soft-primary">{{ trans('home.ar') }}</span>
                                            <div class="col-md-12 mb-3">
                                                <label for="link_ar">{{ trans('home.slug') }}</label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ trans('home.slug') . ' ' . __('home.ar') }}"
                                                    name="link_ar">
                                            </div>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="form-group col-4">
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch"
                                                    switch="success" checked />
                                                <label for="switch" data-on-label="{{ trans('home.yes') }}"
                                                    data-off-label="{{ trans('home.no') }}"></label>
                                                <label class="form-check-label mx-3" for="switch">
                                                    {{ trans('home.publish') }}</label>
                                            </div>
                                        </div>
                                        <div class="form-group col-4">
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="free" id="free"
                                                    switch="success" />
                                                <label for="free" data-on-label="{{ trans('home.yes') }}"
                                                    data-off-label="{{ trans('home.no') }}"></label>
                                                <label class="form-check-label mx-3" for="free">
                                                    {{ trans('home.free') }}</label>
                                            </div>
                                        </div>
                                        <div class="mt-4">
                                            <button type="submit"
                                                class="btn btn-primary w-md">{{ trans('home.save') }}</button>
                                            <a href="{{ url('/admin/chapters') }}"><button type="button"
                                                    class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                                    {{ trans('home.cancel') }}</button></a>
                                        </div>
                                    </div>
                                {!! Form::close() !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->
        </div>
    @endsection
    @section('script')
        {{-- change course --}}
        <script>
            $('#course_id').change(function () {
                var course_id = $(this).val();
                var chapters = $('#chapter_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    url: '{{ route("getChapters")  }}',
                    data: {course_id: course_id},
                    success: function( data ) {
                        console.log(data);
                        var html = '';
                        html += '<option>اختر الفصل</option>'
                        for(var i=0;i<data.length;i++){
                            html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                        }
                        chapters.html(html);
                    }
                });
            });
        </script>
    @endsection
