@extends('layouts.admin')
<title>{{ trans('home.instructors') }}</title>

@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.instructors') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.instructors') }}</li>
                </ol>
            </div>
            @can('instructors_operations')
                <div class="btn btn-list">
    
                   {{-- <a href="{{ route('un_assign_instructor') }}"><button class="btn ripple btn-warning">
                                <i class="fas fa-times-circle"></i> {{ trans('home.delete_trainings_of_instructors') }}</button></a>
                        <a class="mr-2" href="{{ route('assign_instructor') }}" id="assign_instructors" ><button class="btn ripple btn-info"><i
                                    class="fas fa-plus-circle"></i> {{ trans('home.assign_instructors') }}</button></a> --}}
                     
                    @can('instructors_add_button')
                        <a class="mr-2" href="{{ route('instructors.create') }}"><button class="btn ripple btn-primary"><i
                                    class="fas fa-plus-circle"></i> {{ trans('home.add') }}</button></a>
                    @endcan
                    @can('instructors_delete_button')
                        @if(auth()->user()->type != 'partner')
                            <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                                    {{ trans('home.publish/unpublish') }}</button></a>
                        @endif
                        <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                                {{ trans('home.delete') }}</button></a>
                    @endcan
                </div>
            @endcan
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.instructors') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>

                        {{--<div class="d-flex justify-content-between">
                                <form method="post" action="{{ url('course-import-excel') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="col-md-4">
                                        <label>{{trans('home.Exel')}}</label>
                                        <div class="input-group mb-1">
                                            <div class="input-group-prepend"> 
                                                <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                            </div>
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="excelFile" required>
                                                <label class="custom-file-label"
                                                    for="inputGroupFile01">{{ trans('home.choose_excel_file') }}</label>
                                            </div>
                                        </div>
                                        @error('excelFile')
                                            <div class="alert alert-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <button class="btn ripple btn-primary col-md-2" type="submit"><i
                                            class="fas fa-plus-circle"></i>
                                        {{ trans('home.importExcel') }}</button>
                                </form>
                            </div> --}}
                        
                        
                        @can('instructors_centers_filter')
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.center')}}</label>
                                    <div class="row">
                                            <div class="col-8">    
                                                <select id="centers" class="form-control select2  " name="centers" required>
                                            <option value="">{{ __('home.choose_center') }}</option>
                                            <option value="all" @if(Request::segment(4) == 'all') selected @endif>{{ __('home.Select_all') }}</option>
                                            @foreach($centers_selectors as $centers_selector)
                                                <option value="{{$centers_selector->id}}" @if(Request::segment(4) == $centers_selector->id) selected @endif>
                                                    {{$centers_selector->{'name_'.$lang} }}
                                                </option>
                                            @endforeach
                                        </select>
                                            </div>
                                    </div>
                                </div>
                            </div>
                        @endcan
                        
                        
                        <div class="d-flex justify-content-left m-3">
                            <input style="width:15px; margin-left:5px" type="checkbox" name="checkbox" class="tableChecked" value="Select All" id="checkAll"/>
                            <label style="font-size:20px; padding-top:10px" for="checkAll">{{trans('home.select_all')}}</label>
                        </div>

                        {!! $dataTable->table(['class' => 'table table-bordered w-100']) !!}
                        
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection

@section('script')
    <script>
        $('#centers').change(function () {
            var id = $(this).val();
             var url = "{{url('admin/instructors-filter')}}/"+id;
            window.location.href = url ;
        });
    </script>
    {!! $dataTable->scripts() !!}
@endsection
