@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.edit_instructor') }}</title>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.instructors') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('instructors.index') }}">{{ trans('home.instructors') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.edit_instructor') }}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        {!! Form::open([
            'method' => 'PATCH',
            'url' => route('instructors.update',$user->id),
            'data-toggle' => 'validator',
            'files' => 'true',
        ]) !!}

       
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.account_data')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.full_name')}} <span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control @error('f_name') is-invalid @enderror" name="f_name" type="text" placeholder="{{trans('home.name')}}" required value="{{ old('f_name',$user->f_name) }}" >
                                @error('f_name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.ssn')}} <span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control @error('ssn') is-invalid @enderror" name="ssn" type="text" placeholder="{{trans('home.ssn')}}" required value="{{ old('ssn',$user->instructor_info->ssn) }}" >
                                @error('ssn')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
    
                        
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.email')}}</label>
                                <input class="form-control @error('email') is-invalid @enderror" name="email" type="email" placeholder="{{ trans('home.email') }}" value="{{ old('email',$user->email) }}">
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                                <br>
                                <span style='padding:6px 2px;width:fit-content' class="badge badge-warning">{{ trans('home.email_and_password_warning') }}</span>
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.password')}}</label>
                                <input class="form-control area1 @error('password') is-invalid @enderror" name="password" type="password" placeholder="{{trans('home.password')}}"value="{{ old('password') }}">
                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.nationality')}} <span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2 nationality @error('nationality') is-invalid @enderror" name="nationality" required >
                                    <option value="">{{ __('home.choose_nationality') }}</option>
                                    @foreach($nationalities as $nationality)
                                        <option @if(app()->getLocale() == 'en') value="{{$nationality->country_enNationality}}" @selected(old('nationality',$user->instructor_info->nationality) == $nationality->country_enNationality) @else value="{{$nationality->country_arNationality}}" @selected(old('nationality',$user->instructor_info->nationality) == $nationality->country_arNationality) @endif  >{{(app()->getLocale() == 'en')?$nationality->country_enNationality:$nationality->country_arNationality}}</option>
                                    @endforeach
                                </select>
                                @error('nationality')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.mobile')}} <span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control area1 @error('mobile') is-invalid @enderror" name="mobile" type="tel" required placeholder="{{trans('home.mobile')}}"value="{{ old('mobile',$user->instructor_info->mobile) }}">
                                @error('mobile')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.whatsapp')}} <span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control area1 @error('whatsapp') is-invalid @enderror" name="whatsapp" type="tel" required placeholder="{{trans('home.whatsapp')}}"value="{{ old('whatsapp',$user->instructor_info->whatsapp) }}">
                                @error('whatsapp')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            
                            
                            
                            <div class="col-md-3">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input  @error('image') is-invalid @enderror" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                                @error('image')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            @if($user->image)
                                <div class="col-md-5">
                                    <img src="{{url('uploads/users/source/'.$user->image)}}" width="200" height="150">
                                </div>
                            @endif
                            
                            @can('status_or_publish_field')
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.publish')}}</label>
                                <select class="form-control select2 " name="status" id="">
                                    <option value="1" @if($user->status==1) selected @endif>{{ __('home.active') }}</option>
                                    <option value="0" @if($user->status==0) selected @endif>{{ __('home.inactive') }}</option>
                                </select>
                            </div>
                            @endcan
                    </div>
                    </div>
                </div>
               
                <!--account_details-->
                <div class="card custom-card overflow-hidden">
                    <div class="card-body"> 
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.account_details')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                        
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.specialization')}}</label>
                                <input class="form-control @error('specialization') is-invalid @enderror" name="specialization" type="text" placeholder="{{trans('home.specialization')}}"  value="{{ old('specialization',$user->instructor_info->specialization) }}" >
                                @error('specialization')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.sub_specialization')}}</label>
                                <input class="form-control @error('sub_specialization') is-invalid @enderror" name="sub_specialization" type="text" placeholder="{{trans('home.sub_specialization')}}" value="{{ old('sub_specialization',$user->instructor_info->sub_specialization) }}" >
                                @error('sub_specialization')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.job_title')}} </label>
                                <input class="form-control @error('job_title') is-invalid @enderror" name="job_title" type="text" placeholder="{{trans('home.job_title')}}" value="{{ old('job_title',$user->instructor_info->job_title) }}" >
                                @error('job_title')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label for="cv">{{trans('home.cv')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control @error('cv') is-invalid @enderror" type="file" id="cv" @if(!$user->instructor_info->cv) required @endif name="cv" accept=".pdf,.ppt,.pptx,.doc,.docx,.zip">
                                @error('cv')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                                
                                @if($user->instructor_info->cv)
                                    <div class="form-group col-md-12 mb-4 d-flex align-items-center">
                                        <a href="{{url('uploads/instructors/cvs/files/'. $user->instructor_info->cv)}}" download="{{$user->instructor_info->cv}}">
                                          <i class="fas fa-download"></i>
                                        {{$user->instructor_info->cv}}</a>
                                    </div>
                                @endif
                                
                            </div>
                            <div style="display:none" class="form-group col-md-3">
                                <label class="">{{trans('home.registration_date')}}</label>
                                <input class="form-control @error('registration_date') is-invalid @enderror" name="registration_date" type="text" placeholder="{{trans('home.registration_date')}}" required value="{{ old('registration_date',$user->instructor_info->registration_date) }}" >
                                @error('registration_date')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.country')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2 country @error('country_id') is-invalid @enderror" name="country_id" required >
                                    <option value="">{{ __('home.choose_country') }}</option>
                                    @foreach($countries as $country)
                                        <option value="{{$country->id}}"  @selected(old('country_id',$user->instructor_info->address ? $user->instructor_info->address->country_id : '') == $country->id)>{{(app()->getLocale() == 'en')?$country->name_en ?? '':$country->name_ar ?? ''}}</option>
                                    @endforeach
                                </select>
                                @error('country_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.area')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <select class="form-control select2 area @error('area_id') is-invalid @enderror" name="area_id" required>
                                <option value="">{{ __('home.choose_area') }}</option>
                            </select>
                            @error('area_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.region')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <select class="form-control select2 region @error('region_id') is-invalid @enderror" name="region_id" required>
                                <option value="">{{ __('home.choose_region') }}</option>
                            </select>
                            @error('region_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        
                        
                        {{--<div class="form-group col-md-3">
                            <label class="">{{trans('home.address')}}</label>
                            <input class="form-control @error('address') is-invalid @enderror" name="address" type="text" placeholder="{{trans('home.address')}}" required value="{{ old('address',$user->instructor_info->address->address) }}" >
                            @error('address')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.building_num')}}</label>
                            <input class="form-control @error('building_num') is-invalid @enderror" name="building_num" type="number" placeholder="{{trans('home.building_num')}}" required value="{{ old('building_num',$user->instructor_info->address->building_num) }}" >
                            @error('building_num')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.flat_num')}}</label>
                            <input class="form-control @error('flat_num') is-invalid @enderror" name="flat_num" type="number" placeholder="{{trans('home.flat_num')}}" required value="{{ old('flat_num',$user->instructor_info->address->flat_num) }}" >
                            @error('flat_num')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.land_mark')}}</label>
                            <input class="form-control @error('land_mark') is-invalid @enderror" name="land_mark" type="text" placeholder="{{trans('home.land_mark')}}" required value="{{ old('land_mark',$user->instructor_info->address->land_mark) }}" >
                            @error('land_mark')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div> --}}
                        </div>
                        
                    </div>
                </div>
                 <!--center-->
                 @if(auth()->user()->type != 'partner')
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.center')}}</h6>
                            <hr>
                        </div>
                        <?php
                        $usercentersIds = [];
                            if ($user) {
                                $usercentersIds = $user->centers->pluck('center_id')->toArray();
                            }
                        ?>
                        <div class="row">
                           <div class="form-group col-md-12">
                                <label class="">{{trans('home.center')}}</label>
                                <select class="form-control select2  @error('centers') is-invalid @enderror" name="centers[]" multiple>
                                    <option value="">{{ __('home.choose_center') }}</option>
                                    @foreach($centers as $center)
                                        <option value="{{$center->id}}" @if(in_array($center->id,$usercentersIds)) selected @endif>{{$center->{'name_'.$lang} }}</option>
                                    @endforeach
                                </select>
                                @error('centers')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                @else
                    <input type="hidden" name="centers[]" value="{{ auth()->user()->partner->first()->centers()->first()->id }}">
                @endif
                
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                            <a href="{{route('instructors.index')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                        </div>
                    </div>
                </div>

        {!! Form::close() !!}
    </div>
@endsection

@section('script')
    <script>
        $('.country').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getAreas')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    area.html(html);
                }
            });
        });

        $('.area').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getRegions')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    region.html(html);
                }
            });
        });
    </script>
    <script>
        $("#datepicker").datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
    </script>
@endsection
