@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.assign_instructors')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.instructors')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('instructors.index')}}">{{trans('home.instructors')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.assign_instructors')}}</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
        <!-- End Page Header -->
            {!! Form::open(['route' => 'assign_instructor.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
               
                @csrf
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.center')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.center')}}</label>
                                <select class="form-control select2 country @error('center') is-invalid @enderror" name="center" required>
                                    <option value="">{{ __('home.choose_center') }}</option>
                                    @foreach($centers as $center)
                                        <option value="{{$center->id}}">{{$center->{'name_'.$lang} }}</option>
                                    @endforeach
                                </select>
                                @error('center')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        @error('instructors')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                            <div class="table-responsive">
                                <table class="table" id="exportexample">
                                    <thead>
                                        <tr>
                                            <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                            <th>{{ trans('home.id') }}</th>
                                            <th >{{ trans('home.ssn') }}</th>
                                            <th >{{ trans('home.name') }}</th>
                                            <th >{{ trans('home.email') }}</th>
                                            <th >{{ trans('home.status') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($users as $instructor)
                                            <tr id="{{ $instructor->id }}">
                                                <td> <input type="checkbox" name="instructors[]" class="tableChecked" value="{{ $instructor->id }}" /> </td>
                                                <td><a  href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->id }}</a>  </td>
                                                <td><a  href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->instructor_info?$instructor->instructor_info->ssn:'' }}</a>  </td>
                                                <td><a  href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->f_name.' '.$instructor->l_name }}</a> </td>
                                                <td><a  href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->email}}</a> </td>
                                                <td><a  href="{{ route('instructors.edit', $instructor->id) }}">{{ $instructor->status==1? __('home.active') : __('home.inactive') }}</a> </td>
                                            </tr>
                                        @endforeach
    
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div>
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                            <a href="{{route('instructors.index')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                        </div>
                    </div>
                </div>
                    
            {!! Form::close() !!}
        </div>
    </div>
</div>

@endsection

@section('script')
    <script>
        $('.country').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getRegions')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    region.html(html);
                }
            });
        });

        $('.region').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getAreas')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    area.html(html);
                }
            });
        });
    </script>
@endsection