@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_center_hall')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.center_halls')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('center_halls.index')}}">{{trans('home.center_halls')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_center_hall')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    {!! Form::open(['route' => 'center_halls.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.add_center_hall')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-4">
                                @error('name_en') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.hall_name_en')}}</label>
                                <input class="form-control" name="name_en" type="text" value="{{ old('name_en') }}" placeholder="{{trans('home.hall_name_en')}}" >
                            </div>

                            <div class="form-group col-md-4">
                                @error('name_ar') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.hall_name_ar')}} <span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control" name="name_ar" type="text" value="{{ old('name_ar') }}" placeholder="{{trans('home.hall_name_ar')}}" required>
                            </div>
                            
                            
                            <div class="col-md-4">
                                @error('logo') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label>{{ trans('home.logo') }}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="logo">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{ trans('home.choose_logo') }}</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-2">
                                @error('building_name') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.building_name')}} <span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control" name="building_name" value="{{ old('building_name') }}" type="text" placeholder="{{trans('home.building_name')}}" required>
                            </div>
                            <div class="form-group col-md-2">
                                @error('floor') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.floor')}} <span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control" name="floor" value="{{ old('floor') }}" type="text" placeholder="{{trans('home.floor')}}" required>
                            </div>
                            @if(auth()->user()->type != "partner")
                                <div class="form-group col-md-2">
                                    @error('center_id') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                    <label class="">{{trans('home.partner')}}<span style="color: red;padding: 0 3px">*</span></label>
                                    <select class="form-control select2" name="center_id" required id="" {{auth()->user()->type=="partner"?'disabled':''}}>
                                        <option value="">{{ __('home.choose_center') }}</option>
                                        @foreach ($centers as $center)
                                            <option value ="{{$center->id}}" @selected(old('center_id')== $center->id)>{{(app()->getLocale()=='en')? $center->name_en:$center->name_ar}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @else
                               {{-- <div style="display:none" class="form-group col-md-2">
                                     @error('center_id') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                    <label class="">{{trans('home.partner')}}<span style="color: red;padding: 0 3px">*</span></label>
                                    <select  class="form-control select2" name="center_id" id="" {{auth()->user()->type=="partner"?'disabled':''}}>
                                        <option value="">{{ __('home.choose_center') }}</option>
                                        @foreach ($centers as $center)
                                            <option value ="{{$center->id}}" @selected(auth()->user()->partner->first()->centers()->first()->id== $center->id)>{{(app()->getLocale()=='en')? $center->name_en:$center->name_ar}}</option>
                                        @endforeach
                                    </select>
                                </div> --}}
                                <input type="hidden" name="center_id" value="{{ auth()->user()->partner->first()->centers()->first()->id }}">                                
                            @endif

                            <div class="form-group col-md-2">
                                @error('type') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.type_hall')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2" name="type" id="" required>
                                    <option value="">{{ __('home.choose_type') }}</option>
                                    <option value="practical" @selected(old('type')== 'practical')>{{ __('home.practical') }}</option>
                                    <option value="theoretical" @selected(old('type')== 'theoretical')>{{ __('home.theoretical') }}</option>
                                </select>
                            </div>
                            
                            <div class="form-group col-md-2">
                                @error('disabled_suitable') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.disabled_suitable')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2" name="disabled_suitable" id="" required>
                                    <option value="">{{ __('home.choose_type') }}</option>
                                    <option value="1" @selected(old('disabled_suitable')== 1)>{{ __('home.yes') }}</option>
                                    <option value="0" @selected(old('disabled_suitable')== 0)>{{ __('home.no') }}</option>
                                </select>
                            </div>
                            
                            
                            <div class="form-group col-md-2">
                                @error('capacity') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.capacity')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control" name="capacity" value="{{ old('capacity') }}" type="number" min="0" placeholder="{{trans('home.capacity')}}" required>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.country')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2 country @error('country_id') is-invalid @enderror" name="country_id" id="" required>
                                    <option value="">{{ __('home.choose_country') }}</option>
                                    @foreach($countries as $country)
                                        <option value="{{$country->id}}">{{(app()->getLocale() == 'en')?$country->name_en:$country->name_ar}}</option>
                                    @endforeach
                                </select>
                                @error('country_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        
                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.area')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <select class="form-control select2 area @error('area_id') is-invalid @enderror" name="area_id" required>
                                <option value="">{{ __('home.choose_area') }}</option>
                            </select>
                            @error('area_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.region')}}<span style="color: red;padding: 0 3px">*</span></label>
                            <select class="form-control select2 region @error('region_id') is-invalid @enderror" name="region_id" required>
                                <option value="">{{ __('home.choose_region') }}</option>
                            </select>
                            @error('region_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                            
                            <div class="form-group col-md-3">
                                @error('address_en') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.address_en')}}</label>
                                <input class="form-control" name="address_en" value="{{ old('address_en') }}" type="text" placeholder="{{trans('home.address_en')}}" >
                            </div>
                            
                            <div class="form-group col-md-3">
                                @error('address_ar') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.address_ar')}}</label>
                                <input class="form-control" name="address_ar" value="{{ old('address_ar') }}" type="text" placeholder="{{trans('home.address_ar')}}">
                            </div>
                            <div class="form-group col-md-6">
                                @error('map_url') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.map_url')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <textarea class="form-control" name="map_url" type="text" placeholder="{{trans('home.map_url')}}" required>{{ old('map_url') }}</textarea>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
      
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                <a href="{{route('center_halls.index')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    {!! Form::close() !!}
</div>

@endsection

@section('script')
    <script>
        $('.country').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getAreas')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    area.html(html);
                }
            });
        });

        $('.area').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getRegions')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    region.html(html);
                }
            });
        });
    </script>

    <script>
        $( "#datepicker" ).datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
    </script>
@endsection

