@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_training_field')}}</title>
@endsection
@section('content')

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.fields')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/brands')}}">{{trans('home.fields')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_training_field')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    {!! Form::open(['method'=>'PATCH','url' => 'admin/fields/'.$field->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.edit_training_field')}}</h6>
                        </div>
                        
                        <div class="row">

                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.name_en')}}</label>
                                <input class="form-control" name="name_en" type="text" placeholder="{{trans('home.name_en')}}"  value="{{$field->name_en}}" >
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.name_ar')}}</label>
                                <input class="form-control" name="name_ar" type="text" placeholder="{{trans('home.name_ar')}}" value="{{$field->name_ar}}" required >
                            </div>

                            <div class="form-group col-md-3">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-1">
                                <label class="">{{trans('home.alt_img')}}</label>
                                <input class="form-control" name="alt_img" type="text" placeholder="{{trans('home.alt_img')}}" alue="{{$field->alt_img}}">
                            </div>

                            @if($field->image)
                                <div class="col-md-12">
                                    <img style="border-radius:50%" src="{{url('uploads/fields/'.$field->image)}}" width="120">
                                </div>
                            @endif
                            
                            <div class="form-group col-md-6">
                                    <label class="">{{trans('home.text_en')}}</label>
                                    <textarea class="form-control area1" name="text_en"  placeholder="{{trans('home.text_en')}}">{{$field->text_en}}</textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.text_ar')}}</label>
                                    <textarea class="form-control area1" name="text_ar"  placeholder="{{trans('home.text_ar')}}">{{$field->text_ar}}</textarea>
                                </div>
                            @can('status_or_publish_field')
                            <div class="form-group col-md-6">
                                <p class="mt-4 mb-2">{{trans('home.publish')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input" {{($field->status == 1)? 'checked':''}}>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                </label>
                            </div>
                            @endcan
                            
                            <div class="form-group col-md-6">
                                <p class="mt-4 mb-2">{{trans('home.menu')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="menu" value="1" class="custom-switch-input" {{($field->menu == 1)? 'checked':''}}>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish_in_menu')}}</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.seo_block')}}</h6>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge badge-success">{{trans('home.en')}}</span>
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label for="name_ar">{{trans('home.link')}}</label>
                                        <input type="text" autocomplete="off"  class="form-control" placeholder="{{trans('home.link')}}" name="link_en" value="{{$field->link_en}}">
                                    </div> 
                                        
                                    <div class="form-group col-md-5">
                                        <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                        <textarea class="form-control" name="meta_title_en" placeholder="{{trans('home.meta_title')}}">{{$field->meta_title_en}}</textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-5">
                                        <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                        <textarea class="form-control" name="meta_desc_en" placeholder="{{trans('home.meta_desc')}}">{{$field->meta_desc_en}}</textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge badge-success">{{trans('home.ar')}}</span>
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label for="name_ar">{{trans('home.link')}}</label>
                                        <input type="text" autocomplete="off"  class="form-control" placeholder="{{trans('home.link')}}" name="link_ar" value="{{$field->link_ar}}">
                                    </div>
                                    
                                    <div class="form-group col-md-5">
                                        <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                        <textarea class="form-control" name="meta_title_ar" placeholder="{{trans('home.meta_title')}}">{{$field->meta_title_ar}}</textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-5">
                                        <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                        <textarea class="form-control" name="meta_desc_ar" placeholder="{{trans('home.meta_desc')}}">{{$field->meta_desc_ar}}</textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <p class="mt-4 mb-2">{{trans('home.meta_robots')}}</p>
                                        <label class="custom-switch">
                                            <input type="checkbox" name="meta_robots" value="1" class="custom-switch-input" {{($field->meta_robots == 1)? 'checked':''}}>
                                            <span class="custom-switch-indicator"></span>
                                            <span class="custom-switch-description">{{trans('home.click_to_index')}}</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin/fields')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>                                
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    {!! Form::close() !!}
</div>

@endsection
