@extends('layouts.admin')
<title>{{trans('home.faq')}}</title>
@section('content')

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.faq')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.faq')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{trans('home.faqs')}}</h6>
                        <hr>
                    </div>
                    <div class="row">
                        @if(count($questions) > 0)
                            @foreach($questions as $key=>$question)
                                <div class="form-group col-md-2"> 
                                    <label for="question_en">{{trans('home.question_en')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.question_en')}}" readonly>{{$question->question_en}}</textarea>
                                </div>

                                <div class="form-group col-md-3">
                                    <label for="answer_en">{{trans('home.answer_en')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.answer_en')}}" readonly>{{$question->answer_en}}</textarea>
                                </div>
                                
                                
                                <div class="form-group col-md-2"> 
                                    <label for="question_ar">{{trans('home.question_ar')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.question_ar')}}" readonly>{{$question->question_ar}}</textarea>
                                </div>

                                <div class="form-group col-md-3">
                                    <label for="answer_ar">{{trans('home.answer_ar')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.answer_ar')}}" readonly>{{$question->answer_ar}}</textarea>
                                </div>

                                <div class="form-group col-md-2">
                                    <button type="button" style="margin-top: 28px;" class="btn" data-toggle="modal" data-target="#iconForm_{{$key}}"><i class="fas fa-edit"></i></button>
                                    <button type="button" style="margin-top: 28px;" class="btn rmv" data-faq_id="{{$question->id}}" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                </div>
                            @endforeach   
                            <div class="form-group col-md-12 text-center">
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addfAQ"><i class="fas fa-plus-circle"></i> {{trans('home.add_faq')}} </button>
                            </div>
                        @else
                            <div class="form-group col-md-12 text-center">
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addfAQ"><i class="fas fa-plus-circle"></i> {{trans('home.add_faq')}} </button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>    
        </div>
    </div>
    <!-- End Row -->


    <!-- add Modal --> 
    <div class="modal fade text-left" id="addfAQ" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="myModalLabel34">{{trans('home.add_faq')}}</h3>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{route('storeGeneralFaq')}}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="form-group col-md-6"> 
                                <label for="question_en">{{trans('home.question_en')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.question_en')}}" name="question_en"></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="answer_en">{{trans('home.answer_en')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.answer_en')}}" name="answer_en"></textarea>
                            </div>

                            <div class="form-group col-md-6"> 
                                <label for="question_ar">{{trans('home.question_ar')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.question_ar')}}" name="question_ar"></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="answer_ar">{{trans('home.answer_ar')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.answer_ar')}}" name="answer_ar"></textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success">{{trans('home.save')}} </button>
                            </div>
                        </div>                             
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- edit Modal -->
    @foreach($questions as $key=>$question)
        <div class="modal fade text-left" id="iconForm_{{$key}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title" id="myModalLabel34">{{trans('home.edit_faq')}}</h3>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{route('updateGeneralFaq')}}" method="post">
                        @csrf
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-md-6"> 
                                    <label for="question_en">{{trans('home.question_en')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.question_en')}}" name="question_en">{{$question->question_en}}</textarea>
                                </div>
    
                                <div class="form-group col-md-6">
                                    <label for="answer_en">{{trans('home.answer_en')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.answer_en')}}" name="answer_en">{{$question->answer_en}}</textarea>
                                </div>
                                
                                
                                <div class="form-group col-md-6"> 
                                    <label for="question_ar">{{trans('home.question_ar')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.question_ar')}}" name="question_ar">{{$question->question_ar}}</textarea>
                                </div>
    
                                <div class="form-group col-md-6">
                                    <label for="answer_ar">{{trans('home.answer_ar')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.answer_ar')}}" name="answer_ar">{{$question->answer_ar}}</textarea>
                                </div> 

                                <input type="hidden" name="faq_id" value="{{$question->id}}"/>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success">{{trans('home.save')}} </button>
                                </div>
                            </div>                             
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
</div>

@endsection


@section('script')
    <script type="text/javascript">
        $(document).ready(function(){
            $('.rmv').click(function () {
                var faq_id = $(this).data('faq_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"{{route('removeGeneralFaq')}}",
                    method:'POST',
                    data: {faq_id:faq_id},
                    success:function(data) {
                        location.reload();
                    }
                });
            });
        });

    </script>
@endsection