@extends('layouts.admin')
<title>{{ trans('home.exames') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.exames') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.exames') }}</li>
                </ol>
            </div>
            @can('exams_opertions')
                <div class="btn btn-list">
                    @can('exams_add_button')
                        <a href="{{ route('exames.create') }}"><button class="btn ripple btn-primary"><i
                                    class="fas fa-plus-circle"></i> {{ trans('home.add') }}</button></a>
                    @endcan
                    @can('exams_delete_buttons')
                        <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                                {{ trans('home.publish/unpublish') }}</button></a>
                        <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                                {{ trans('home.delete') }}</button></a>
                    @endcan
                </div>
            @endcan
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.exames') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th >{{ trans('home.name') }}</th>
                                        <th class="wd-25p">{{ trans('home.course') }}</th>
                                        <th class="wd-25p">{{ trans('home.duration') }}</th>
                                        <th>{{ trans('home.n_questions') }}</th>
                                        <th>{{ trans('home.status') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($exames as $exame)
                                        <tr id="{{ $exame->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" value="{{ $exame->id }}" /> </td>
                                            <td><a href="{{ route('exames.edit', $exame->id) }}">{{ $exame->id }}</a>  </td>
                                            <td><a href="{{ route('exames.edit', $exame->id) }}">{{ $exame->{'name_'.$lang} }}</a>  </td>
                                            <td><a href="{{ route('exames.edit', $exame->id) }}">{{ $exame->course->{'name_'.$lang} ?? '' }}</a>  </td>
                                            <td><a href="{{ route('exames.edit', $exame->id) }}">{{ $exame->duration }}</a>  </td>
                                            <td><a href="{{ route('questions.show', $exame->id) }}">{{ count($exame->questions) }}</a>  </td>
                                            <td><a  href="{{ route('exames.edit', $exame->id) }}">{{ $exame->status==1? __('home.active') : __('home.inactive') }}</a> </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
