@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_question')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.questions')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('questions.index')}}">{{trans('home.questions')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_question')}}</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
        <div class="overflow-hidden">
            <div class="card-body">
                <!-- End Page Header -->
                {!! Form::open(['route' => 'questions.store', 'data-toggle'=>'validator']) !!}
                    <!-- Row-->
                    @csrf
                    <div class="card custom-card ">
                        <div class="card-body row">

                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.question_en')}}</label>
                                <input class="form-control @error('question_en') is-invalid @enderror" name="question_en" type="text" placeholder="{{trans('home.question_en')}}" required value="{{ old('question_en') }}" >
                                @error('question_en')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
    
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.question_ar')}}</label>
                                <input class="form-control @error('question_ar') is-invalid @enderror" name="question_ar" type="text" placeholder="{{ trans('home.question_ar') }}" value="{{ old('question_ar') }}">
                                @error('question_ar')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-4">
                                <label for="exame">{{trans('home.exames')}}</label>
                                <select class="form-control select2 @error('exame') is-invalid @enderror" name="exame">
                                    @foreach($exames as $exame)
                                        <option value="{{$exame->id}}">{{$exame->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                                @error('exame')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                            </div>
                            
                            @can('status_or_publish_field')
                            <div class="form-group col-md-12">
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" checked class="custom-switch-input"/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.publish')}}</span>
                                </label>
                            </div>
                            @endcan
                            
                        </div>
                    </div>
                    <div class="card custom-card">
                        <div class="card-body row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                <a href="{{route('exames.index')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                    <!-- End Row -->
                {!! Form::close() !!}
            </div>
        </div>
    </div>
    </div>
</div>

@endsection

