@extends('layouts.admin')
<title>{{trans('home.crm_employess_targets').' | '.trans('home.crm')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
            </div>

            <div class="row btn btn-list gap-3 mx-3">
                <a href="{{url('admin/crm/crm-employess/targets/create')}}">
                    <button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i>
                        {{trans('home.add').' '.trans('home.crm_employess_targets')}}
                    </button> 
                </a>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th>{{trans('home.id')}}</th>
                                    <th>{{trans('home.name')}}</th>
                                    <th>{{trans('home.delete')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($targets as $target)
                                    <tr id="{{$target->id}}">
                                        <td> {{$target->id}} </td>
                                        <td><a href="{{ url('admin/crm/crm-employess/targets/'. $target->id) }}"> {{$target->name}}</a> </td>
                                        <td>
                                            <a class="btn btn_delete_crm" data-id="{{ $target->id }}" href="#" title="{{ trans('home.delete') }}">
                                                <i class="fal fa-trash text-danger"></i>
                                            </a>
                                        {{--
                                            <a class="btn btn_delete_crm" data-id="{{$target->id}}"
                                            href="{{ url('admin/crm/crm-employess/targets/'. $target->id.'/delete') }}" 
                                                title='{{trans('home.delete')}}'> 
                                                <i class="fal fa-trash text-danger"></i>
                                            </a>
                                            --}}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
<script>
    $(document).ready(function(){
        $('.btn_delete_crm').click(function(e){
            e.preventDefault(); // Prevent the default link action
            
            var id = $(this).data('id'); // Get the data-id attribute
            var deleteUrl = "{{ url('admin/crm/crm-employess/targets') }}/" + id + "/delete"; // Construct the delete URL

            Swal.fire({
                title: '{{__('home.Are you sure you want to delete that ?')}}',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: '{{ __("home.delete") }}',
                cancelButtonText: '{{ __("home.cancel") }}'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: deleteUrl,
                        type: 'GET',
                        data: { id: id },
                        success: function(response) {
                            // Fade out the row after successful deletion
                            $('tr#' + id).css('background-color', '#ccc').fadeOut('slow');
                        },
                        error: function(xhr) {
                            Swal.fire(
                                '{{ __("home.Error") }}',
                                '{{ __("home.An error occurred while deleting.") }}',
                                'error'
                            );
                        }
                    });
                }
            });
        });
    });
</script>

@endsection
