@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.crm_employess_targets')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm_employess_targets')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/crm/crm-employess/targets')}}">{{trans('home.crm_employess_targets')}}</a></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    {!! Form::open(['route' => ['targets.update',$target->id], 'data-toggle'=>'validator']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div class="row">

                            <div class="form-group col-md-6">
                                <label for="name">{{trans('home.name')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.name')}}" value="{{$target->name}}"name="name" required>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="call_daily">{{trans('home.call_daily')}}</label>
                                <input type="number"  class="form-control" required value="{{$target->call_daily}}"name="call_daily">
                            </div>

                            <div class="form-group col-md-6">
                                <label for="call_monthly">{{trans('home.call_monthly')}}</label>
                                <input type="number"  class="form-control" required value="{{$target->call_monthly}}"name="call_monthly">
                            </div>

                            <div class="form-group col-md-6">
                                <label for="meeting_daily">{{trans('home.meeting_daily')}}</label>
                                <input type="number"  class="form-control" required value="{{$target->meeting_daily}}"name="meeting_daily">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="meeting_monthly">{{trans('home.meeting_monthly')}}</label>
                                <input type="number"  class="form-control" required value="{{$target->meeting_monthly}}"name="meeting_monthly">
                            </div>

                            <div class="form-group col-md-6">
                                <label for="budget_monthly">{{trans('home.budget_monthly')}}</label>
                                <input type="number"  class="form-control" required value="{{$target->budget_monthly}}"name="budget_monthly">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="budget_yearly">{{trans('home.budget_yearly')}}</label>
                                <input type="number" class="form-control" required value="{{$target->budget_yearly}}"name="budget_yearly">
                            </div>
                            
                             <div class="form-group text-center col-md-12 mt-4">
                                <button type="submit" class="btn btn-success"><i class="image-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin/crm/crm-employess/targets/admin/blog-items')}}"><button type="button" class="btn btn-danger mr-1"><i class="image-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
       
    {!! Form::close() !!}
</div>

@endsection
