@extends('layouts.admin')
<title>{{trans('home.'.$status).' | '.trans('home.crm')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.'.$status)}}</h2>
            </div>
            <div class="row btn btn-list gap-3 mx-3">
                <a href="{{url('admin/crm/reports')}}"><button class="btn ripple btn-primary">
                    {{trans('home.reports')}}</button> 
                </a>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th>{{trans('home.id')}}</th>
                                    <th class="wd-20p">{{trans('home.client')}}</th>
                                    <th class="wd-25p">{{trans('home.whatsapp')}}</th>
                                    <th class="wd-25p">{{trans('home.detials')}}</th>
                                    <th class="wd-25p">{{trans('home.saved').' / '.trans('home.sent')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($whatsapps as $whatsapp)
                                    <tr id="{{$whatsapp->id}}">
                                        <td> {{$whatsapp->id}}</td>
                                        <td> {{$whatsapp->client->name}}</td>
                                        <td> {{$whatsapp->sent_to}}</td>
                                        <td> {{$whatsapp->message}}</td>
                                        <td> {{__('home.'.$whatsapp->sent)}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
