@extends('layouts.admin')
<title>{{trans('home.'.$status).' | '.trans('home.crm')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.'.$status)}}</h2>
            </div>
            <div class="row btn btn-list gap-3 mx-3">
                <a href="{{url('admin/crm/reports')}}"><button class="btn ripple btn-primary">
                    {{trans('home.reports')}}</button> 
                </a>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th>{{trans('home.id')}}</th>
                                    <th class="wd-20p">{{trans('home.name')}}</th>
                                    <th class="wd-25p">{{trans('home.phone')}}</th>
                                    <th class="wd-25p">{{trans('home.whatsapp')}}</th>
                                    <th class="wd-25p">{{trans('home.ssn')}}</th>
                                    <th class="wd-25p">{{trans('home.email')}}</th>
                                    <th class="wd-25p">{{trans('home.nationality')}}</th>
                                    <th class="wd-25p">{{trans('home.qualification')}}</th>
                                    <th class="wd-25p">{{trans('home.region')}}</th>
                                    <th class="wd-25p">{{trans('home.area')}}</th>
                                    <th class="wd-15p">{{trans('home.training')}}</th>
                                    <th class="wd-15p">{{trans('home.start_date')}}</th>
                                    <th class="wd-15p">{{trans('home.end_date')}}</th>
                                    <th class="wd-15p">{{trans('home.come_from')}}</th>
                                    <th class="wd-15p">{{trans('home.client_status')}}</th>
                                    <th class="wd-15p">{{trans('home.responsible_employee')}}</th>
                                    <th class="wd-15p">{{trans('home.payment_status')}}</th>
                                    <th class="wd-15p">{{trans('home.company')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($clients as $client)
                                    <tr id="{{$client->id}}">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$client->id}}" /> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->id}}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->name}}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->phone}}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->whatsapp}}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->ssn}}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->email}}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->nationality}}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->qualification}}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->area?->{'name_'.$lang} }}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->region?->{'name_'.$lang} }}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> 
                                                    {!! $client->companyTraining?->map(function($training) use($lang) {
                                                    return "<span class='badge badge-primary m-1'>" . $training->training->{'name_' . $lang} . "</span>";
                                                })->implode(' ') !!}
                                            </a> 
                                        </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->training?->training->start_date }}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->training?->training->end_date }}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->source?->{'name_'.$lang} }} </a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->status?->{'name_'.$lang} }}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> {{$client->responsible_employee?->user?->name() }}</a> </td>
                                        <td><a href="{{url('admin/crm/clients/'.$client->id)}}"> 
                                        @if($client->training)
                                            @if($client->training->payment_status=="paid")
                                                <span class='badge badge-success m-1'>
                                                    {{__('home.paid') }}
                                                </span>
                                            @else
                                                <span class='badge badge-danger m-1'>
                                                    {{__('home.un_paid') }}
                                                </span>
                                            @endif
                                        @endif
                                        </a> </td>
                                        <td><a href="{{url('admin/crm/client/'.$client->id)}}"> {{$client->company?$client->company->name: __('home.no_company') }}</a> </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
