@extends('layouts.admin')
<title>{{trans('home.edit')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.edit')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('admin/crm/companies')}}">{{trans('home.companies')}}</a></li>
                </ol>
            </div>

        </div>
        <!-- End Page Header -->
        
           <!-- End Page Header -->
    <form method="post" action="{{url('admin/crm/companies/'.$company->id.'/update')}}" id="client_form">
        @csrf
   
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.edit').' | '.$company->name}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.name')}}</label>
                                <input class="form-control" name="name" type="text" placeholder="{{trans('home.name')}}" value="{{$company->name}}" required>
                            </div>

                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.email')}}</label>
                                <input class="form-control" name="email" type="email" placeholder="{{trans('home.email')}}" value="{{$company->email}}" required>
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.phone')}}</label>
                                <input class="form-control" name="phone" type="text" placeholder="{{trans('home.phone')}}" value="{{$company->phone}}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.whatsapp')}}</label>
                                <input class="form-control" name="whatsapp" type="text" placeholder="{{trans('home.whatsapp')}}" value="{{$company->whatsapp}}">
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">الموقع الالكترونى</label>
                                <input class="form-control" name="company_website" value="{{$company->company_data->company_website}}" type="text" placeholder="الموقع الالكترونى" >
                            </div>
                            <div class="form-group col-md-4">
                                <label for="parent">مسار البيع</label>
                                <select class="form-control select2" name="category">
                                    <option value="maharat" {{$company->company_data->category=="maharat"?'selected':''}}>@lang('home.maharat')</option>
                                    <option value="special" {{$company->company_data->category=="special"?'selected':''}}>@lang('home.special')</option>
                                    <option value="special-maharat" {{$company->company_data->category=="special-maharat"?'selected':''}}>@lang('home.special-maharat')</option>
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.field')}}</label>
                                <select class="form-control select2" name="field_id">
                                    @foreach($fields as $field)
                                    <option value="{{$field->id}}"
                                    {{$company->company_data->field_id==$field->id?"selected":""}}>{{$field->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            
                            
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.country')}}</label>
                                <select class="form-control select2 country"  name="country_id">
                                    @foreach($countries as $country)
                                        <option value="{{$country->id}}" {{$company->country_id==$country->id?"selected":""}}>{{$country->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.area')}}</label>
                                <select class="form-control select2 region"  name="area_id">
                                    @foreach($areas as $area)
                                        <option value="{{$area->id}}" {{$company->area_id==$area->id?"selected":""}}>{{$area->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.region')}}</label>
                                <select class="form-control select2 area"  name="region_id">
                                    @foreach($regions as $region)
                                        <option value="{{$region->id}}" {{$company->region_id==$region->id?"selected":""}}>{{$region->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            <hr>
                           
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.responsible_contact_person')}}</label>
                                <input class="form-control" value="{{$company->company_data->responsible_contact_person}}"
                                name="responsible_contact_person" type="text" 
                                placeholder="{{trans('home.responsible_contact_person')}}" required>
                            </div>
                             <div class="form-group col-md-3">
                                <label class="">رقم جوال المسؤول</label>
                                <input class="form-control" value="{{$company->company_data->responsible_contact_phone}}" name="responsible_contact_phone" type="text" placeholder="{{trans('home.responsible_contact_person')}}{{trans('home.phone')}}">
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">وظيفة المسؤول</label>
                                <select class="form-control select2" name="job">
                                    <option {{$company->company_data->job=="االمدير التنفيذي"?"checked":""}} value="االمدير التنفيذي">االمدير التنفيذي</option>
                                    <option {{$company->company_data->job=="مدير التدريب"?"checked":""}} value="مدير التدريب">مدير التدريب</option>
                                    <option {{$company->company_data->job=="مدير الموارد البشرية"?"checked":""}} value="مدير الموارد البشرية">مدير الموارد البشرية</option>
                                </select>
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">بريد المسؤول</label>
                                <input class="form-control" value="{{$company->company_data->responsible_contact_email}}" name="responsible_contact_email" type="email" placeholder="بريد المسؤول">
                            </div>
                            
                            
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.come_from')}}</label>
                                <select class="form-control select2" name="come_from">
                                    <option value="">@lang('home.come_from')</option>
                                    @foreach($sources as $source)
                                    <option value="{{$source->id}}"  {{$company->come_from==$source->id?"selected":""}}>{{$source->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                             @if(auth()->user()->type=="admin")
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.responsible_employee')}}</label>
                                <select class="form-control select2 "  name="responsible_employee">
                                    @foreach($crm_employees as $crm_employee)
                                        <option value="{{$crm_employee->id}}" 
                                            {{$company->responsible_employee?($company->responsible_employee->user?->id==$crm_employee->id?"selected":""):''}}>
                                            {{$crm_employee->name() }}
                                        </option>
                                    @endforeach    
                                </select>
                            </div>
                            @else
                                <div class="form-group col-md-3">
                                    <label class=""> {{trans('home.responsible_employee')}}</label>
                                    <input class="form-control" value="{{$company->responsible_employee->user?->id}}" 
                                        placeholder="{{$company->responsible_employee->user?->name()}}"
                                    disabled value="{{$company->company_data->responsible_contact_email}}" name="responsible_employee">
                                </div>
                            @endif
                            

                        </div>                                
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->



        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <a>
                                    <button type="submit" class="btn btn-success text-white">
                                    <i class="icon-note"></i> {{ trans('home.update') }}
                                </a>
                                <a href="{{ url('/admin/crm/companies') }}">
                                    <button type="button" class="btn btn-danger mr-1">
                                        <i class="icon-trash"></i> {{ trans('home.cancel') }}
                                    </button>
                                </a>
                            </div>
                        </div>                                
                    </div>
                </div>
            </div>
        </div>
    </form>
    </div>
@endsection

@section('script')
    <!--areas and regions-->
     <script>
        $('.country').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('getAreas')  }}',
                data: {id: id},
                success: function (data) {
                    var html = '';
                    html += '<option></option>'
                    for (var i = 0; i < data.length; i++) {
                        html += '<option  value="' + data[i].id + '">@if(\App::getLocale() == 'en')' + data[i].name_en + ' @else ' + data[i].name_ar + ' @endif</option>';
                    }
                    region.html(html);
                    $('#select_country').html('');
                }
            });
        });

        $('.region').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('getRegions')  }}',
                data: {id: id},
                success: function (data) {
                    var html = '';
                    html += '<option></option>'
                    for (var i = 0; i < data.length; i++) {
                        html += '<option  value="' + data[i].id + '">@if(\App::getLocale() == 'en')' + data[i].name_en + ' @else ' + data[i].name_ar + ' @endif</option>';
                    }
                    area.html(html);
                    $('.shipping_total').html("{{ __('home.select your area first')}}");
                    $('#select_region').html('');
                    
                }
            });
        });

    </script>

@endsection
