@extends('layouts.admin')
<title>{{trans('home.companies').' | '.trans('home.crm')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.companies')}}</h2>
            </div>

            <div class="row btn btn-list gap-3 mx-3">
                <a href="{{url('admin/crm/add-company/single')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add_company')}}</button> </a>
                <a id="btn_delete_crm" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th>{{trans('home.id')}}</th>
                                    <th class="wd-20p">{{trans('home.name')}}</th>
                                    <th class="wd-25p">نوع الشركة</th>
                                    <th class="wd-25p">{{trans('home.field')}}</th>
                                    <th class="wd-25p">{{trans('home.region')}}</th>
                                    <th class="wd-25p">{{trans('home.area')}}</th>
                                    {{--<th class="wd-15p">حالة الشركة</th>--}}
                                    {{--<th class="wd-15p">{{trans('home.come_from')}}</th>--}}
                                    <th class="wd-15p">{{trans('home.responsible_contact_person')}}</th>
                                    <th class="wd-15p">بريد المسؤول بالشركة</th>
                                    <th class="wd-15p">{{trans('home.responsible_employee')}}</th>
                                    <th class="wd-15p">متدربى الشركة</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($clients as $client)
                                    <tr id="{{$client->id}}">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$client->id}}" /> </td>
                                        <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->id}}</a> </td>
                                        <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->name}}</a> </td>
                                        <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{__('home.'.$client->company_data->category)}}</a> </td>
                                        <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->company_data->field?->{'name_'.$lang} }}</a> </td>
                                        <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->company_data->area?->{'name_'.$lang} }}</a> </td>
                                        <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->company_data->region?->{'name_'.$lang} }}</a> </td>
                                        {{--<td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->status?->{'name_'.$lang} }}</a> </td>--}}
                                        {{-- <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client->source?$client->source->{'name_'.$lang}:$client->come_from }} </a> </td>--}}
                                        <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client?->company_data->responsible_contact_person }} </a> </td>
                                        <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client?->company_data->responsible_contact_email }} </a> </td>
                                        {{--<td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client?->company_data->job }} </a> </td>--}}
                                        <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> {{$client?->responsible_employee?->user->name() }} </a> </td>
                                        <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> 
                                            {{ count($client->clients) }}
                                                </a> 
                                        </td>
                                        {{--
                                        <td><a href="{{url('admin/crm/companies/'.$client->id)}}"> 
                                            {!! $client->clients?->map(function($company_client) use($lang) {
                                                    return "<span class='badge badge-primary m-1'>" . $company_client->name . "</span>";
                                                })->implode(' ') !!}
                                                </a> 
                                        </td>
                                        --}}
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
<script>
     $(document).ready(function(){
            $('#btn_delete_crm').click(function(){
                var id = [];
                <?php
                $last_word = Request::segment(3);
                // return $last_word;
                Session::put('route', $last_word);
                ?>
                $('.tableChecked:checked').each(function(i){
                    id[i] = $(this).val();
                });
                if(id.length === 0) //tell you if the array is empty
                {
                    alert("Please Select atleast one checkbox");
                }
                else
                {
                    $.confirm({
                        title: '{{__('home.Are you sure you want to delete that ?')}}',
                        content:'',
                        buttons: {
                            confirm: {
                                text: '{{__('home.delete')}}',
                                btnClass: 'btn-red any-other-class',
                                keys: ['enter', 'shift'],
                                action: function(){
                                     $.ajaxSetup({
                                        headers: {
                                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                        }
                                    });
                    
                                    $.ajax({
                                        url: "{{url('admin/crm/clients/delete/')}}" +'/'+ id,
                                        type: 'POST',
                                        data: {id: id},
                                        success: function () {
                                            for (var i = 0; i < id.length; i++) {
                                                $('tr#' + id[i]).css('background-color', '#ccc').fadeOut('slow');
                                                $('input:checkbox[value="' + id[i] + '"]').removeClass('tableChecked').removeAttr('checked');
                                            }
                                        }
                                    }); 
                                }
                            },
                            cancel: {
                                text: '{{__('home.cancel')}}',
                                action: function(){
                                    close();
                                }
                            }
                        }
                    });
                }
            });
        });
        
</script>
@endsection
