@extends('layouts.admin')
<title>{{trans('home.add_company')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header row">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.add_company')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('admin/crm/companies')}}">{{trans('home.companies')}}</a></li>
                </ol>
            </div>
             <form class="row" action="{{ route('crm_company.upload') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="custom-file col-6">
                    <input type="file" class="file" id="inputGroupFile01" name="company_file">
                    <label class="custom-file-label" for="inputGroupFile01">{{trans('home.add_company_excel')}}</label>
                </div>
                <div class="col-auto">
                    <button type="submit" class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i>
                        {{trans('home.add_company_excel')}}
                    </button> 
                    <a href="{{Helper::uploadedImagesPath('templates','crm_company.xlsx')}}" 
                    class="btn ripple btn-primary text-white"><i class="fe fe-arrow-down"></i>
                        {{trans('home.download_template')}}
                    </a> 
                </div>
             </form>

        </div>
        <!-- End Page Header -->
        
           <!-- End Page Header -->
    <form method="post" action="{{route('store_single_Company')}}" id="company_form">
        @csrf
   
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.add_company')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.name')}} {{' '.trans('home.company')}}</label>
                                <input class="form-control" name="name" type="text" placeholder="{{trans('home.name')}}" required>
                            </div>
 
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.email')}}</label>
                                <input class="form-control" name="email" type="email" placeholder="{{trans('home.email')}}" required>
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.phone')}}</label>
                                <input class="form-control" name="phone" type="text" placeholder="{{trans('home.phone')}}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.whatsapp')}}</label>
                                <input class="form-control" name="whatsapp" type="text" placeholder="{{trans('home.whatsapp')}}">
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">الموقع الالكترونى</label>
                                <input class="form-control" name="company_website" type="text" placeholder="الموقع الالكترونى" >
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label for="parent">مسار البيع</label>
                                <select class="form-control select2" name="category">
                                    <option value="maharat">@lang('home.maharat')</option>
                                    <option value="special">@lang('home.special')</option>
                                    <option value="special-maharat">@lang('home.special-maharat') </option>
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.field')}}</label>
                                <select class="form-control select2" name="field_id">
                                    @foreach($fields as $field)
                                    <option value="{{$field->id}}">{{$field->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                             <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.country')}}</label>
                                <select class="form-control select2 country"  name="country_id">
                                        <option disabled selected>{{__('home.country')}}</option>
                                    @foreach($countries as $country)
                                        <option value="{{$country->id}}">{{$country->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.area')}}</label>
                                <select class="form-control select2 region"  name="area_id">
                                    <option disabled selected>{{__('home.area')}}</option>
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.region')}}</label>
                                <select class="form-control select2 area"  name="region_id">
                                    <option disabled selected>{{__('home.region')}}</option>
                                </select>
                            </div>
                            
                            
                            
                            <hr>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.responsible_contact_person')}}</label>
                                <input class="form-control" name="responsible_contact_person" type="text" placeholder="{{trans('home.responsible_contact_person')}}" required>
                            </div>
                             <div class="form-group col-md-3">
                                <label class="">رقم جوال المسؤول</label>
                                <input class="form-control" name="responsible_contact_phone" type="text" placeholder="{{trans('home.responsible_contact_person')}}{{trans('home.phone')}}">
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">وظيفة المسؤول</label>
                                <select class="form-control select2" name="job">
                                    <option value="االمدير التنفيذي">االمدير التنفيذي</option>
                                    <option value="مدير التدريب">مدير التدريب</option>
                                    <option value="مدير الموارد البشرية">مدير الموارد البشرية</option>
                                </select>
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">بريد المسؤول</label>
                                <input class="form-control" name="responsible_contact_email" type="email" placeholder="بريد المسؤول">
                            </div>
                            <div class="form-group col-md-4 d-none">
                                <label for="parent">موقف الشركة</label>
                                <input type="hidden" value="19" name="status_id">
                                {{--
                                <select class="form-control select2" name="status_id">
                                    @foreach($statuses as $status)
                                        <option value="{{$status->id}}">{{$status->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                                --}}
                            </div>
                            {{--
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.training')}}</label>
                                <select class="form-control select2" name="training_id[]" multiple required>
                                    @foreach($trainings as $training)
                                        <option value="{{$training->id}}">{{$training->{'name_'.$lang} }}</option>
                                    @endforeach
                                </select>
                            </div>
                            --}}
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.come_from')}}</label>
                                <select class="form-control select2" name="come_from">
                                    @foreach($sources as $source)
                                    <option value="{{$source->id}}">{{$source->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            @if(auth()->user()->type=="admin")
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.responsible_employee')}}</label>
                                <select class="form-control select2 "  name="responsible_employee">
                                    @foreach($crm_employees as $crm_employee)
                                        <option value="{{$crm_employee->id}}" 
                                            {{isset($company)?($company->responsible_employee->user?->id==$crm_employee->id?"selected":""):''}}>
                                            {{$crm_employee->name() }}
                                        </option>
                                    @endforeach    
                                </select>
                            </div>
                            @else
                                <input type="hidden" name="responsible_employee" value="{{auth()->id()}}">
                            @endif
                        </div>                                
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->



        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <a data-reset="save" class="save btn btn-success text-white">
                                    <i class="icon-note"></i> {{ trans('home.save') }}
                                </a>
                                <a data-reset="save_and_another" class="save btn btn-success text-white">
                                    <i class="icon-note"></i> {{ trans('home.save_and_another') }}
                                </a>
                                <a href="{{ url('/admin/crm/companies') }}">
                                    <button type="button" class="btn btn-danger mr-1">
                                        <i class="icon-trash"></i> {{ trans('home.cancel') }}
                                    </button>
                                </a>
                            </div>
                        </div>                                
                    </div>
                </div>
            </div>
        </div>
    </form>
    </div>
@endsection

@section('script')
    <script>
        $('.save').click(function(event) {
            event.preventDefault(); 
            var formData = $('#company_form').serialize();
            var reset = $(this).data('reset');
    
            $.ajax({
                type: 'POST',
                url: "{{ route('store_single_Company') }}",
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}' // Include CSRF token for security
                },
                success: function(response) {
                    if (response.status === 'error') {
                        Swal.fire({
                            icon: 'error',
                            title: '{{ trans("home.error") }}',
                            text: response.message
                        });
                    } else if (response.status === 'success') {
                        Swal.fire({
                            icon: 'success',
                            title: '{{ trans("home.registeration_success") }}',
                            text: response.message
                        }).then(() => {
                            if(reset==="save_and_another"){
                                window.location.reload(); // Reload the page after successful submission
                            }else{
                             window.location.replace("{{ url('admin/crm/companies') }}");
                            }
                        });
                    }
                },
                error: function(xhr, status, error) {
                    if (xhr.status === 422) { // Validation error
                        var errors = xhr.responseJSON.errors;
                        var errorMessages = '';
                        
                        // Loop through each validation error and concatenate the messages
                        $.each(errors, function(key, value) {
                            errorMessages += value[0] + '<br>';
                        });
        
                        // Display the validation errors using Swal or in your form
                        Swal.fire({
                            icon: 'error',
                            title: '{{ trans("home.error") }}',
                            html: errorMessages // Use html to display multiple errors
                        });
                    } else {
                        // For other errors
                        var errorMessage = xhr.status + ': ' + xhr.statusText;
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: errorMessage // Display a user-friendly error message
                        });
                    }
                }
            });
        });
    </script>
    
    <!--areas and regions-->
     <script>
        $('.country').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('getAreas')  }}',
                data: {id: id},
                success: function (data) {
                    var html = '';
                    html += '<option></option>'
                    for (var i = 0; i < data.length; i++) {
                        html += '<option  value="' + data[i].id + '">@if(\App::getLocale() == 'en')' + data[i].name_en + ' @else ' + data[i].name_ar + ' @endif</option>';
                    }
                    region.html(html);
                    $('#select_country').html('');
                }
            });
        });

        $('.region').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('getRegions')  }}',
                data: {id: id},
                success: function (data) {
                    var html = '';
                    html += '<option></option>'
                    for (var i = 0; i < data.length; i++) {
                        html += '<option  value="' + data[i].id + '">@if(\App::getLocale() == 'en')' + data[i].name_en + ' @else ' + data[i].name_ar + ' @endif</option>';
                    }
                    area.html(html);
                    $('.shipping_total').html("{{ __('home.select your area first')}}");
                    $('#select_region').html('');
                    
                }
            });
        });

    </script>
    
    

@endsection
