@extends('layouts.admin')
<title>{{trans('home.financial')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.crm')}}</h2>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.financial')}}</h2>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="d-flex btn btn-list gap-3 m-3">
                        <a href="javascript:void(0)" class="filter_type" data-type="company">
                            <button class="btn ripple btn-primary"><i class="fas fa-filter"></i> {{trans('home.companies')}}</button>
                        </a>
                        <a href="javascript:void(0)" class="filter_type" data-type="client">
                            <button class="btn ripple btn-primary"><i class="fas fa-filter"></i> {{trans('home.clients')}}</button>
                        </a>
                        <a href="javascript:void(0)" class="filter_type d-none" id="clear" data-type="clear">
                            <button class="btn ripple btn-primary"><i class="fas fa-times"></i> {{trans('home.show all')}}</button>
                        </a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th>{{trans('home.id')}}</th>
                                        <th>{{trans('home.client').' / '.trans('home.company')}}</th>
                                        <th>{{trans('home.invoice_number')}}</th>
                                        <th>{{trans('home.discount')}}</th>
                                        <th>{{trans('home.invoice_value')}}</th>
                                        <th>نوع الحساب</th>
                                        <th>حالة المتدرب</th>
                                        <th>{{trans('home.details')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($invoices as $invoice)
                                        <tr id="{{$invoice->id}}" class="type_{{$invoice->client?->type}} clientrecord">
                                            <td> {{ $invoice->id }}</td>
                                            <td> {{ $invoice->client?->name }}</td>
                                            <td> {{ $invoice->invoice_number }}</td>
                                            <td> {{ $invoice->discount??'-' }}</td>
                                            <td> {{ $invoice->invoice_value }}</td>
                                            <td> {{ __('home.'.$invoice->client?->type) }}</td>
                                            <td> {{ __('home.'.$invoice->invoice_status) }}</td>
                                            <td><a class="btn btn-primary" target="_blank" href="{{ url('admin/crm/invoice/'.$invoice->id) }}">{{trans('home.details')}}</a></td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
    					</div>
					
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
    
@endsection
@section('script')
    <script>
        $('.filter_type').click(function(){
            var type = $(this).data('type');
            $('.filter_type button').removeClass('btn-info').addClass('btn-primary');
            $(this).find('button').removeClass('btn-primary').addClass('btn-info');
            
            if(type == "client"){
                $('.clientrecord').addClass('d-none'); 
                $('.type_client').removeClass('d-none'); 
                $('#clear').removeClass('d-none'); 
                
            } 
            else if(type == "company"){
                $('.clientrecord').addClass('d-none'); 
                $('.type_company').removeClass('d-none'); 
                $('#clear').removeClass('d-none'); 
            }
            else if(type == "clear"){
                $('.clientrecord').removeClass('d-none'); 
                $('#clear').addClass('d-none'); 
            }
        });
    </script>
@endsection