@extends('layouts.admin')
<title>{{trans('home.edit')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.edit')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('admin/crm/clients')}}">{{trans('home.clients')}}</a></li>
                </ol>
            </div>

        </div>
        <!-- End Page Header -->
        
           <!-- End Page Header -->
    <form method="post" action="{{url('admin/crm/clients/'.$client->id.'/update')}}" id="client_form">
        @csrf
   
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.add_client')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.name')}}</label>
                                <input class="form-control" name="name" type="text" placeholder="{{trans('home.name')}}" value="{{$client->name}}" required>
                            </div>

                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.email')}}</label>
                                <input class="form-control" name="email" type="email" placeholder="{{trans('home.email')}}" value="{{$client->email}}" required>
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.phone')}}</label>
                                <input class="form-control" name="phone" type="text" placeholder="{{trans('home.phone')}}" value="{{$client->phone}}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.phone')}}2</label>
                                <input class="form-control" name="phone2" type="text" placeholder="{{trans('home.phone')}}2" value="{{$client->phone}}">
    2                        </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.whatsapp')}}</label>
                                <input class="form-control" name="whatsapp" type="text" placeholder="{{trans('home.whatsapp')}}" value="{{$client->whatsapp}}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.ssn')}}</label>
                                <input class="form-control" name="ssn" type="text" placeholder="{{trans('home.ssn')}}" value="{{$client->ssn}}" >
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.nationality')}}</label>
                                <input class="form-control" name="nationality" type="text" placeholder="{{trans('home.nationality')}}" value="{{$client->nationality}}" >
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.qualification')}}</label>
                                <input class="form-control" name="qualification" type="text" placeholder="{{trans('home.qualification')}}" value="{{$client->qualification}}" >
                            </div>
                            <div class="form-group col-md-3">
                                <label for="parent">{{trans('home.client_status')}}</label>
                                <select class="form-control select2" name="status_id">
                                    @foreach($statuses as $status)
                                        <option value="{{$status->id}}" {{$client->status->id==$status->id?"selected":""}}>{{$status->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            <div class="form-group col-md-3">
                                <label for="parent">{{trans('home.company')}}</label>
                                <select class="form-control select2" name="company_id">
                                        <option value="">@lang('home.no_company')</option>
                                    @foreach($companies as $company)
                                        <option value="{{$company->id}}" {{$client->company_id==$company->id?"selected":""}}>{{$company->name }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            <div class="form-group col-md-3">
                                <label for="parent">{{trans('home.come_from')}}</label>
                                <select class="form-control select2" name="come_from">
                                    <option value="">@lang('home.come_from')</option>
                                    @foreach($sources as $source)
                                    <option value="{{$source->id}}" {{$client->come_from==$source->id?"selected":""}}>{{$source->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                             <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.responsible_employee')}}</label>
                                <select class="form-control select2 "  name="responsible_employee">
                                        <option  selected>{{ auth()->user()->name()}}</option>
                                    @foreach($crm_employees as $crm_employee)
                                        <option value="{{$crm_employee->id}}" {{$client->responsible_employee?($client->responsible_employee->user?->id==$crm_employee->id?"selected":""):''}}>{{$crm_employee->name() }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.country')}}</label>
                                <select class="form-control select2 country"  name="country_id">
                                        <option disabled selected>{{__('home.country')}}</option>
                                    @foreach($countries as $country)
                                        <option value="{{$country->id}}" {{$client->country_id==$country->id?"selected":""}}>{{$country->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.area')}}</label>
                                <select class="form-control select2 region"  name="area_id">
                                    <option disabled selected>{{__('home.area')}}</option>
                                    @foreach($areas as $area)
                                        <option value="{{$area->id}}" {{$client->area_id==$area->id?"selected":""}}>{{$area->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.region')}}</label>
                                <select class="form-control select2 area"  name="region_id">
                                    @foreach($regions as $region)
                                        <option value="{{$region->id}}" {{$client->region_id==$region->id?"selected":""}}>{{$region->{'name_'.$lang} }}</option>
                                    @endforeach    
                                </select>
                            </div>

                        </div>                                
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->



        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <a>
                                    <button type="submit" class="btn btn-success text-white">
                                    <i class="icon-note"></i> {{ trans('home.update') }}
                                </a>
                                <a href="{{ url('/admin/crm/clients') }}">
                                    <button type="button" class="btn btn-danger mr-1">
                                        <i class="icon-trash"></i> {{ trans('home.cancel') }}
                                    </button>
                                </a>
                            </div>
                        </div>                                
                    </div>
                </div>
            </div>
        </div>
    </form>
    </div>
@endsection

@section('script')
    <!--areas and regions-->
     <script>
        $('.country').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('getAreas')  }}',
                data: {id: id},
                success: function (data) {
                    var html = '';
                    html += '<option></option>'
                    for (var i = 0; i < data.length; i++) {
                        html += '<option  value="' + data[i].id + '">@if(\App::getLocale() == 'en')' + data[i].name_en + ' @else ' + data[i].name_ar + ' @endif</option>';
                    }
                    region.html(html);
                    $('#select_country').html('');
                }
            });
        });

        $('.region').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('getRegions')  }}',
                data: {id: id},
                success: function (data) {
                    var html = '';
                    html += '<option></option>'
                    for (var i = 0; i < data.length; i++) {
                        html += '<option  value="' + data[i].id + '">@if(\App::getLocale() == 'en')' + data[i].name_en + ' @else ' + data[i].name_ar + ' @endif</option>';
                    }
                    area.html(html);
                    $('.shipping_total').html("{{ __('home.select your area first')}}");
                    $('#select_region').html('');
                    
                }
            });
        });

    </script>

@endsection
