@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.courses')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/courses')}}">{{trans('home.courses')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_course')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    {!! Form::open(['method'=>'PATCH','url' => 'admin/courses/'.$course->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.course_info')}}</h6>
                            <hr>
                        </div>
                        
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['method'=>'PATCH','url' => 'admin/courses/'.$course->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <label for="name_en">{{trans('home.name_en')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.name_en')}}" name="name_en" value="{{$course->name_en}}"  required>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label for="name_ar">{{trans('home.name_ar')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.name_ar')}}" name="name_ar" value="{{$course->name_ar}}"  required>
                                        </div>
                                        
                                        <div class="col-md-6 mb-3 ">  
                                            <label for="text_en">{{trans('home.text_en')}}</label>
                                            <textarea class="form-control ckeditor-classic area1" placeholder="{{trans('home.text_en')}}" name="text_en">{{$course->text_en}}</textarea>
                                        </div>                                      
                                        <div class="col-md-6 mb-3 ">  
                                            <label for="text_ar">{{trans('home.text_ar')}}</label>
                                            <textarea class="form-control ckeditor-classic area1" placeholder="{{trans('home.text_ar')}}" name="text_ar">{{$course->text_ar}}</textarea>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="form-group col-4">                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch" switch="success" {{$course->status?'checked':''}}/>
                                                <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                                <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                            </div>
                                        </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                        <a href="{{url('/admin/courses')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                    </div>


                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
</div>
@endsection


@section('script')
    <script>
        document.getElementById('switch_discount').addEventListener('change', function() {
            var discountDiv = $('.discount_div') ;
            if (this.checked) {
                $('.discount_div').removeClass('d-none')
            } else {
                $('.discount_div').addClass('d-none')
            }
        });
    </script>
@endsection

