@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_chapter')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.chapters')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('chapters.index')}}">{{trans('home.chapters')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_chapter')}}</li>
            </ol>
        </div>
    </div>

        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['route' => 'chapters.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                    <div class="row">

                                        <div class="col-md-3 mb-3">
                                            <label for="name_en">{{trans('home.name_en')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.name_en')}}" name="name_en" required>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="name_ar">{{trans('home.name_ar')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.name_ar')}}" name="name_ar" required>
                                        </div>


                                        <div class="col-md-3 mb-3">
                                            <label for="level_id">{{trans('home.course')}}</label>
                                            <select class="form-control" data-trigger name="course_id">
                                                <option value="" >{{ trans('home.choose_course') }}</option>
                                                @foreach($courses as $course)
                                                    <option value="{{$course->id}}" >{{$course->{'name_'.$lang} }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="duration">{{trans('home.duration')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.duration')}}" name="duration" required>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="order">{{trans('home.order')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.order')}}" name="order"  required>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="form-group col-4">                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch" switch="success" checked/>
                                                <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                                <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                            </div>
                                        </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                        <a href="{{url('/admin/chapters')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection
