@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.schedule_centers')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.schedule_centers')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                @can('centers')
                <li class="breadcrumb-item"><a href="{{route('centers.index')}}">{{trans('home.centers')}}</a></li>
                @endcan
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.schedule_centers')}}</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{trans('home.schedule_centers')}}</h6>
                        <hr>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label class="">{{trans('home.center')}}</label>
                            <div class="row">
                                    <div class="col-8">    
                                        <select id="centers" class="form-control select2  " name="centers" required>
                                    <option value="">{{ __('home.choose_center') }}</option>
                                    <option value="all" @if(Request::segment(4) == 'all') selected @endif>{{ __('home.Select_all') }}</option>
                                    @foreach($centers_selectors as $centers_selector)
                                        <option value="{{$centers_selector->id}}" @if(Request::segment(4) == $centers_selector->id) selected @endif>
                                            {{$centers_selector->{'name_'.$lang} }}
                                        </option>
                                    @endforeach
                                </select>
                                    </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    {{--<th>{{ trans('home.id') }}</th>--}}
                                    <th>{{ trans('home.code') }}</th>
                                    <th >{{ trans('home.name') }}</th>
                                    <th >{{ trans('home.training') }}</th>
                                    <th >{{ trans('home.instructor') }}</th>
                                    <th >{{ trans('home.count_students') }}</th>
                                    <th>{{trans('home.certified_std_ratio')}}</th>
                                    <th >{{ trans('home.start_date') }}</th>
                                    <th >{{ trans('home.end_date') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($centers as $center)
                                    @foreach ($center->trainingsSchadual as $trainingsSchadual)
                                        <tr id="{{ $center->id }}">
                                            {{--<td><a  href="javascript::avoid(0)">{{ $center->id }}</a>  </td>--}}
                                            <td><a  href="javascript::avoid(0)">{{ $trainingsSchadual->training->code }}</a>  </td>
                                            <td><a  href="javascript::avoid(0)">{{ $center->{'name_'.$lang} }}</a>  </td>
                                            <td><a  href="javascript::avoid(0)">{{ $trainingsSchadual->training->{'name_'.$lang} }}</a> </td>
                                            <td><a  href="javascript::avoid(0)">{{ $trainingsSchadual->instructor() }}</a> </td>
                                            <td><a  href="javascript::avoid(0)">{{ $trainingsSchadual->training->n_joined() }}</a> </td>
                                            @php
                                                $students = $trainingsSchadual->training->students->filter(function($student) {
                                                    return count($student->attendance) >= 3;
                                                })->where('view_certifiacte',1);
                                            @endphp
                                            <td class="text-center">
                                                <div class="progress-bar bg-success {{(count($trainingsSchadual->training->students) > 0) ? number_format((float)((count($students)/count($trainingsSchadual->training->students)) * 100), 2, '.', '') <= 25 ? 'text-black' : '' : 'text-black'}}" role="progressbar" style="width: {{ (count($trainingsSchadual->training->students) > 0) ? number_format((float)((count($students)/count($trainingsSchadual->training->students)) * 100), 2, '.', '') : 0 }}%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                    {{ (count($trainingsSchadual->training->students) > 0) ? number_format((float)((count($students)/count($trainingsSchadual->training->students)) * 100), 2, '.', '') : 0 }}%
                                                </div>
                                            </td>
                                            <td><a  href="javascript::avoid(0)">
                                                {{\Carbon\Carbon::parse($trainingsSchadual->start_date)->format("d / m / Y")  }}
                                                </a> </td>
                                            <td><a  href="javascript::avoid(0)">
                                                {{\Carbon\Carbon::parse($trainingsSchadual->end_date)->format("d / m / Y")  }}
                                                </a> </td>
                                        </tr>
                                    @endforeach
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
    <script>
        $('#centers').change(function () {
            var id = $(this).val();
             var url = "{{url('admin/schedule_centers')}}/"+id;
            window.location.href = url ;
        });
    </script>
@endsection