@extends('layouts.admin')
@section('meta')
<title>{{trans('home.centers')}}</title>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.centers')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.centers')}}</li>
                </ol>
            </div>
            @can('center_operations')
            <div class="btn btn-list">
                @can('centers_add_buttons')
                    <a href="#" data-bs-toggle="modal" data-bs-target="#importcentersmodel">
                        <button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i>{{__('home.import_centers_excel')}}</button>
                    </a>
                    <a class="mr-2" href="{{route('centers.create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
                @endcan
                @can('centers_delete_buttons')
                    <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> {{trans('home.publish/unpublish')}}</button></a>
                    <a class="mr-2" id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
                @endcan
            </div>
            @endcan
        </div>
        <!-- End Page Header -->

        @if(session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-bs-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.centers')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>
                        <div class="d-flex justify-content-left m-3">
                            <input style="width:15px; margin-left:5px" type="checkbox" name="checkbox" class="tableChecked" value="Select All" id="checkAll"/>
                            <label style="font-size:20px; padding-top:10px" for="checkAll">{{trans('home.select_all')}}</label>
                        </div>
                        {!! $dataTable->table(['class' => 'table table-bordered w-100']) !!}

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        
         <!-- Import Excel  -->
        <div class="modal fade bd-example-modal-lg" id="importcentersmodel" tabindex="-1" role="dialog" aria-labelledby="importcentersmodelTitle" aria-hidden="true">
          <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content" style="border-radius: 35px;">
              <div class="modal-header">
                 <img src="{{url('resources/assets/back/img/centers.png')}}">
                 
              </div>
              <div class="text-center">
                 <span class="text-danger">لاكثر من مسؤول قم باضافة الصف اكثر من مره مع اختلاف تفاصيل المسؤول</span>
             </div>
            <form method="post" action="{{ route('center.import.excel') }}" enctype="multipart/form-data">
                  <div class="modal-body ">
                        <div class="m-auto">
                                @csrf
                                <div class="input-group mb-1 d-flex justify-content-center">
                                    <div class="input-group-prepend"> 
                                        <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                    </div>
                                    <div class="custom-file col-8">
                                        <input type="file" class="custom-file-input" name="excelFile"  accept=".csv,.xlsx">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{ trans('home.choose_excel_file') }}</label>
                                    </div>
                                   
                                </div>
                        </div>
                  </div>
                  <div class="modal-footer  justify-content-center ">
                       <button class="btn ripple btn-primary " type="submit"><i
                                    class="fas fa-plus-circle"></i>
                                    {{ trans('home.importExcel') }}</button>
                    <button id="closeModalButton" type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
                  </div>
            </form>
            </div>
          
          </div>
        </div>
    </div>
@endsection

@section('script')
    {!! $dataTable->scripts() !!}

    <script>
        function viewModel(id){
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: '{{route('viewresponsible.show')}}',
                    method: 'POST',
                    data: {
                        responsible_id: id,
                    },
                    success: function (response) {
                        $('#view_responsibleModal').empty();
                        $('.main-content').append(response.view);
                        $('#view_responsibleModal_'+id).modal('show');
                    }

            });
        }
    </script>
@endsection
