@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.edit_center') }}</title>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.centers') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('centers.index') }}">{{ trans('home.centers') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.edit_center') }}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        {!! Form::open([ 'method' => 'PATCH', 'url' => route('centers.update' , $center->id),'data-toggle' => 'validator', 'files' => 'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.edit_center') }}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-4">
                                @error('name_en') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.name_en')}}</label>
                                <input class="form-control" name="name_en" type="text" value="{{ old('name_en',$center->name_en) }}" placeholder="{{trans('home.name_en')}}">
                            </div>

                            <div class="form-group col-md-4">
                                @error('name_ar') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.name_ar')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control" name="name_ar" type="text" value="{{ old('name_ar',$center->name_ar) }}" placeholder="{{trans('home.name_ar')}}" required>
                            </div>
                            
                            <div class="col-md-4">
                                @error('logo') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label>{{ trans('home.logo') }}<span style="color: red;padding: 0 3px">*</span></label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="logo" required>
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{ trans('home.choose_logo') }}</label>
                                    </div>
                                </div>
                                @if($center->logo)
                                    <img style="height: 150px; margin-top:15px"
                                        src="{{ url("uploads/centers/$center->logo") }}" alt="">
                                @endif
                            </div>    
                            
                            <div class="form-group col-md-4">
                                @error('country_id') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.country')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2 country" name="country_id" id="">
                                    <option value="">{{ __('home.choose_country') }}</option>
                                    @foreach($countries as $country)
                                        <option value="{{$country->id}}" required {{($country->id == $center->country_id)?'selected':''}}>{{(app()->getLocale() == 'en')?$country->name_en:$country->name_ar}}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="form-group col-md-4">
                                @error('area_id') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.area')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2 area" name="area_id" id="">
                                    <option value="">{{ __('home.choose_area') }}</option>
                                    @foreach($areas as $area)
                                        <option value="{{$area->id}}" required {{($area->id == $center->area_id)?'selected':''}}>{{(app()->getLocale() == 'en')?$area->name_en:$area->name_ar}}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="form-group col-md-4">
                                @error('region_id') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.region')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2 region" name="region_id" id="">
                                    <option value="">{{ __('home.choose_region') }}</option>
                                    @foreach($regions as $region)
                                        <option value="{{$region->id}}" required {{($region->id == $center->region_id)?'selected':''}}>{{(app()->getLocale() == 'en')?$region->name_en:$region->name_ar}}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label for="partner_start_date">{{trans('home.partner_start_date')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <div class="input-group">
                                    <input type='text' class="form-control datepicker" name="partner_start_date" required value="{{old('partner_start_date', $center->partner_start_date)}}" placeholder="{{trans('home.partner_start_date')}}"  readonly/>
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-8">
                                @error('map_url') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.map_url')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <textarea class="form-control" name="map_url"type="text" placeholder="{{trans('home.map_url')}}" required>{{ old('map_url',$center->map_url) }}</textarea>
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.responsible_of_contact')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <select class="form-control select2 responsible_of_contact @error('responsible_of_contact') is-invalid @enderror" required name="responsible_of_contact" id="">
                                    <option value="">{{ __('home.choose_responsible_of_contact') }}</option>
                                    @foreach($responsibles as $responsible)
                                        <option @selected($responsible->id == old('responsible_of_contact',$center->responsible_of_contact)) value="{{$responsible->id}}">{{(app()->getLocale() == 'en')?$responsible->f_name:$responsible->f_name}}</option>
                                    @endforeach
                                </select>
                                @error('responsible_of_contact')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label for="identity_attachment">{{trans('home.commericalRegister/identity')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control @error('identity_attachment') is-invalid @enderror" @if(!$center->identity_attachment) required @endif type="file" id="identity_attachment" name="identity_attachment" accept=".pdf,.ppt,.pptx,.doc,.docx,.zip,.jpg,.jpeg,.png">
                                @error('identity_attachment')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                                
                                @if($center->identity_attachment)
                                    <div class="form-group col-md-12 mb-4 d-flex align-items-center">
                                        <a href="{{url('uploads/centers/attachments/'.$center->identity_attachment)}}" download="{{$center->identity_attachment}}">
                                          <i class="fas fa-download"></i>
                                        {{$center->identity_attachment}}</a>
                                    </div>
                                @endif
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label for="national_address">{{trans('home.national_address')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control @error('national_address') is-invalid @enderror" @if(!$center->national_address) required @endif type="file" id="national_address" name="national_address" accept=".pdf,.ppt,.pptx,.doc,.docx,.zip,.jpg,.jpeg,.png">
                                @error('national_address')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                                
                                @if($center->national_address)
                                    <div class="form-group col-md-12 mb-4 d-flex align-items-center">
                                        <a href="{{url('uploads/centers/attachments/'.$center->national_address)}}" download="{{$center->national_address}}">
                                          <i class="fas fa-download"></i>
                                        {{$center->national_address}}</a>
                                    </div>
                                @endif
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label for="profile_attachment">{{trans('home.profile_attachment')}}<span style="color: red;padding: 0 3px">*</span></label>
                                <input class="form-control @error('profile_attachment') is-invalid @enderror" national_address @if(!$center->profile_attachment) required @endif type="file" id="profile_attachment"  name="profile_attachment" accept=".pdf,.ppt,.pptx,.doc,.docx,.zip,.jpg,.jpeg,.png">
                                @error('profile_attachment')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                                
                                @if($center->profile_attachment)
                                    <div class="form-group col-md-12 mb-4 d-flex align-items-center">
                                        <a href="{{url('uploads/centers/attachments/'.$center->profile_attachment)}}" download="{{$center->profile_attachment}}">
                                          <i class="fas fa-download"></i>
                                        {{$center->profile_attachment}}</a>
                                    </div>
                                @endif
                            </div>
                            
                            <div class="form-group col-md-6">
                                 @error('text_en') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.desc_en')}}</label>
                                <textarea class="form-control area1" name="text_en" type="text" placeholder="{{trans('home.desc_en')}}">{{ old('text_en',$center->text_en) }}</textarea>
                            </div>
                            
                            <div class="form-group col-md-6">
                                @error('text_ar') <p class="alert alert-danger">{{ $message }}</p> @enderror
                                <label class="">{{trans('home.desc_ar')}}</label>
                                <textarea class="form-control area1" name="text_ar" type="text" placeholder="{{trans('home.desc_ar')}}">{{ old('text_ar',$center->text_ar) }}</textarea>
                            </div>
                            @can('status_or_publish_field')
                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2">{{trans('home.status')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input" {{($center->status == 1)? 'checked':''}}/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                </label>
                            </div>
                            @endcan
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div>
                                <h6 class="card-title mb-1">{{trans('home.responsible_informations')}}</h6>
                                <hr>
                            </div>

                            <div class="field_wrapper">
                                 @if(count($center_resposibles) > 0)
                                    @foreach($center_resposibles as $key=>$center_resposible)
                                        <div class="row" id="responsible_{{$center_resposible->id}}">
                                            <div class="form-group col-md-2"> 
                                                <label for="responsible_name">{{trans('home.responsible_name')}}</label>
                                                <input type="text"  class="form-control" placeholder="{{trans('home.responsible_name')}}" value="{{$center_resposible->responsible_name}}" disabled>
                                            </div>
        
                                            <div class="form-group col-md-2"> 
                                                <label for="responsible_job">{{trans('home.responsible_job')}}</label>
                                                <input type="text"  class="form-control" placeholder="{{trans('home.responsible_job')}}" value="{{$center_resposible->responsible_job}}" disabled>
                                            </div>
                                            <div class="form-group col-md-2"> 
                                                <label for="responsible_email">{{trans('home.responsible_email')}}</label>
                                                <input type="text"  class="form-control" placeholder="{{trans('home.responsible_email')}}" value="{{$center_resposible->responsible_email}}" disabled>
                                            </div>
        
                                            <div class="form-group col-md-2"> 
                                                <label for="responsible_phone">{{trans('home.responsible_phone')}}</label>
                                                <input type="text"  class="form-control" placeholder="{{trans('home.responsible_phone')}}" value="{{$center_resposible->responsible_phone}}" disabled>
                                            </div>
                                            
                                            <div class="form-group col-md-2"> 
                                                <label for="responsible_whatsapp">{{trans('home.responsible_whatsapp')}}</label>
                                                <input type="text"  class="form-control" placeholder="{{trans('home.responsible_whatsapp')}}" value="{{$center_resposible->responsible_whatsapp}}" disabled>
                                            </div>
                                            
                                            <div class="form-group col-md-2">
                                                <button type="button" style="margin-top: 28px;"  
                                                class="btn editresponsible" 
                                                    data-toggle="modal" data-target="#edit_responsibleModal_{{$center_resposible->id}}" data-responsible_id="{{$center_resposible->id}}">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button type="button" style="margin-top: 28px;" class="btn rmv" data-responsible_id="{{$center_resposible->id}}" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                            </div>
                                        </div> 
                                    @endforeach
                                @else
                                
                                    <div class="row">
                            
                                        <div class="form-group col-md-2">
                                            <label class="">{{trans('home.responsible_name')}}<span style="color: red;padding: 0 3px">*</span></label>
                                            <input class="form-control @error('responsible_name') is-invalid @enderror" name="responsible_name[]" required type="text" placeholder="{{trans('home.responsible_name')}}">
                                            @error('responsible_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group col-md-2">
                                            <label class="">{{trans('home.responsible_job')}}<span style="color: red;padding: 0 3px">*</span></label>
                                            <input class="form-control @error('responsible_job') is-invalid @enderror" name="responsible_job[]" required type="text" placeholder="{{trans('home.responsible_job')}}">
                                            @error('responsible_job')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group col-md-3">
                                            <label class="">{{trans('home.responsible_email')}}<span style="color: red;padding: 0 3px">*</span></label>
                                            <input class="form-control @error('responsible_email') is-invalid @enderror" name="responsible_email[]" required type="email" placeholder="{{trans('home.responsible_email')}}">
                                            @error('responsible_email')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group col-md-2">
                                            <label class="">{{trans('home.responsible_phone')}}<span style="color: red;padding: 0 3px">*</span></label>
                                            <input class="form-control @error('responsible_phone') is-invalid @enderror" name="responsible_phone[]" required type="number" min="0" placeholder="{{trans('home.responsible_phone')}}">
                                            @error('responsible_phone')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        
                                        <div class="form-group col-md-2">
                                            <label class="">{{trans('home.responsible_whatsapp')}}<span style="color: red;padding: 0 3px">*</span></label>
                                            <input class="form-control @error('responsible_whatsapp') is-invalid @enderror" name="responsible_whatsapp[]" required type="number" min="0" placeholder="{{trans('home.responsible_whatsapp')}}">
                                            @error('responsible_whatsapp')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>  
                                @endif
                            </div>       
                            <a href="javascript:void(0);" class="add_button btn" title="Add field"><i class="fas fa-plus-square"></i></a>								
                        </div>
                    </div>
                </div>
            </div>
        
        
        <!-- Row-->
       {{-- <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body"> 
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.responsible_informations') }}</h6>
                            <hr>
                        </div>
                        
                        <div class="row">
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.responsible_name1')}}</label>
                            <input class="form-control @error('responsible_name1') is-invalid @enderror" name="responsible_name1" value="{{ old('responsible_name1',$center->responsible_name1) }}" type="text" placeholder="{{trans('home.responsible_name1')}}">
                            @error('responsible_name1')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_job1')}}</label>
                            <input class="form-control @error('responsible_job1') is-invalid @enderror" name="responsible_job1" value="{{ old('responsible_job1',$center->responsible_job1) }}" type="text" placeholder="{{trans('home.responsible_job1')}}">
                            @error('responsible_job1')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.responsible_email1')}}</label>
                            <input class="form-control @error('responsible_email1') is-invalid @enderror" name="responsible_email1" value="{{ old('responsible_email1',$center->responsible_email1) }}" type="email" placeholder="{{trans('home.responsible_email1')}}">
                            @error('responsible_email1')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_phone1')}}</label>
                            <input class="form-control @error('responsible_phone1') is-invalid @enderror" name="responsible_phone1" value="{{ old('responsible_phone1',$center->responsible_phone1) }}" type="number" min="0" placeholder="{{trans('home.responsible_phone1')}}">
                            @error('responsible_phone1')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.responsible_whatsapp1')}}</label>
                            <input class="form-control @error('responsible_whatsapp1') is-invalid @enderror" name="responsible_whatsapp1" value="{{ old('responsible_whatsapp1',$center->responsible_whatsapp1) }}" type="number" min="0" placeholder="{{trans('home.responsible_whatsapp1')}}">
                            @error('responsible_whatsapp1')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                        <div class="row">
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.responsible_name2')}}</label>
                                <input class="form-control @error('responsible_name2') is-invalid @enderror" name="responsible_name2" value="{{ old('responsible_name2',$center->responsible_name2) }}" type="text" placeholder="{{trans('home.responsible_name2')}}">
                                @error('responsible_name2')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.responsible_job2')}}</label>
                                <input class="form-control @error('responsible_job2') is-invalid @enderror" name="responsible_job2" value="{{ old('responsible_job2',$center->responsible_job2) }}" type="text" placeholder="{{trans('home.responsible_job2')}}">
                                @error('responsible_job2')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.responsible_email2')}}</label>
                                <input class="form-control @error('responsible_email2') is-invalid @enderror" name="responsible_email2" value="{{ old('responsible_email2',$center->responsible_email2) }}" type="email" placeholder="{{trans('home.responsible_email2')}}">
                                @error('responsible_email2')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.responsible_phone2')}}</label>
                                <input class="form-control @error('responsible_phone2') is-invalid @enderror" name="responsible_phone2" value="{{ old('responsible_phone2',$center->responsible_phone2) }}" type="number" min="0" placeholder="{{trans('home.responsible_phone2')}}">
                                @error('responsible_phone2')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.responsible_whatsapp2')}}</label>
                                <input class="form-control @error('responsible_whatsapp2') is-invalid @enderror" name="responsible_whatsapp2" value="{{ old('responsible_whatsapp2',$center->responsible_whatsapp2) }}" type="number" min="0" placeholder="{{trans('home.responsible_whatsapp2')}}">
                                @error('responsible_whatsapp2')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                    </div>
                        <div class="row">
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.responsible_name3')}}</label>
                                <input class="form-control @error('responsible_name3') is-invalid @enderror" name="responsible_name3" value="{{ old('responsible_name3',$center->responsible_name3) }}" type="text" placeholder="{{trans('home.responsible_name3')}}">
                                @error('responsible_name3')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.responsible_job3')}}</label>
                                <input class="form-control @error('responsible_job3') is-invalid @enderror" name="responsible_job3" value="{{ old('responsible_job3',$center->responsible_job3) }}" type="text" placeholder="{{trans('home.responsible_job3')}}">
                                @error('responsible_job3')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.responsible_email3')}}</label>
                                <input class="form-control @error('responsible_email3') is-invalid @enderror" name="responsible_email3" value="{{ old('responsible_email3',$center->responsible_email3) }}" type="email" placeholder="{{trans('home.responsible_email3')}}">
                                @error('responsible_email3')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.responsible_phone3')}}</label>
                                <input class="form-control @error('responsible_phone3') is-invalid @enderror" name="responsible_phone3" value="{{ old('responsible_phone3',$center->responsible_phone3) }}" type="number" min="0" placeholder="{{trans('home.responsible_phone3')}}">
                                @error('responsible_phone3')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.responsible_whatsapp3')}}</label>
                                <input class="form-control @error('responsible_whatsapp3') is-invalid @enderror" name="responsible_whatsapp3" value="{{ old('responsible_whatsapp3',$center->responsible_whatsapp3) }}" type="number" min="0" placeholder="{{trans('home.responsible_whatsapp3')}}">
                                @error('responsible_whatsapp3')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                    </div>
                        <div class="row">
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.responsible_name4')}}</label>
                                <input class="form-control @error('responsible_name4') is-invalid @enderror" name="responsible_name4" value="{{ old('responsible_name4',$center->responsible_name4) }}" type="text" placeholder="{{trans('home.responsible_name4')}}">
                                @error('responsible_name4')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.responsible_job4')}}</label>
                                <input class="form-control @error('responsible_job4') is-invalid @enderror" name="responsible_job4" value="{{ old('responsible_job4',$center->responsible_job4) }}" type="text" placeholder="{{trans('home.responsible_job4')}}">
                                @error('responsible_job4')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.responsible_email4')}}</label>
                                <input class="form-control @error('responsible_email4') is-invalid @enderror" name="responsible_email4" value="{{ old('responsible_email4',$center->responsible_email4) }}" type="email" placeholder="{{trans('home.responsible_email4')}}">
                                @error('responsible_email4')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.responsible_phone4')}}</label>
                                <input class="form-control @error('responsible_phone4') is-invalid @enderror" name="responsible_phone4" value="{{ old('responsible_phone4',$center->responsible_phone4) }}" type="number" min="0" placeholder="{{trans('home.responsible_phone4')}}">
                                @error('responsible_phone4')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.responsible_whatsapp4')}}</label>
                                <input class="form-control @error('responsible_whatsapp4') is-invalid @enderror" name="responsible_whatsapp4" value="{{ old('responsible_whatsapp4',$center->responsible_whatsapp4) }}" type="number" min="0" placeholder="{{trans('home.responsible_whatsapp4')}}">
                                @error('responsible_whatsapp4')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                    </div>
                        <div class="row">
                            
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.responsible_of_contact')}}</label>
                                <select class="form-control select2 responsible_of_contact @error('responsible_of_contact') is-invalid @enderror" name="responsible_of_contact" id="">
                                    <option value="">{{ __('home.choose_responsible_of_contact') }}</option>
                                    @foreach($responsibles as $responsible)
                                        <option @selected($responsible->id == old('responsible_of_contact',$center->responsible_of_contact)) value="{{$responsible->id}}">{{(app()->getLocale() == 'en')?$responsible->f_name:$responsible->f_name}}</option>
                                    @endforeach
                                </select>
                                @error('responsible_of_contact')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                        </div>

                    </div>
                </div>
            </div>
        </div> --}}
        <!-- End Row -->
        
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    {{ trans('home.save') }} </button>
                                <a href="{{ route('centers.index') }}"><button type="button" class="btn btn-danger mr-1"><i
                                            class="icon-trash"></i> {{ trans('home.cancel') }}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        {!! Form::close() !!}
    </div>
@endsection



@section('script')
    <script>
        $('.country').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getAreas')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    area.html(html);
                }
            });
        });

        $('.area').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getRegions')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    region.html(html);
                }
            });
        });
    </script>
    
    <script>
    $(document).ready(function(){
         $( ".datepicker" ).datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
        var maxField = 100; //Input fields increment limitation
        var addButton = $('.add_button'); //Add button selector
        var wrapper = $('.field_wrapper'); //Input field wrapper
        var fieldHTML ='<div class="row"><hr><div class="form-group col-md-2"> <label for="responsible_name">{{trans('home.responsible_name')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.responsible_name')}}" name="responsible_name[]"> </div>';
        fieldHTML +='<div class="form-group col-md-2"> <label for="responsible_job">{{trans('home.responsible_job')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.responsible_job')}}" name="responsible_job[]"> </div>';
        fieldHTML +='<div class="form-group col-md-3"> <label for="responsible_email">{{trans('home.responsible_email')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.responsible_email')}}" name="responsible_email[]"> </div>';
        fieldHTML +='<div class="form-group col-md-2"> <label for="responsible_phone">{{trans('home.responsible_phone')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.responsible_phone')}}" name="responsible_phone[]"> </div>';
        fieldHTML +='<div class="form-group col-md-2"> <label for="responsible_whatsapp">{{trans('home.responsible_whatsapp')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.responsible_whatsapp')}}" name="responsible_whatsapp[]"> </div>';
        fieldHTML +='<div class="form-group col-md-1"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

   
        var x = 1; //Initial field counter is 1

        //Once add button is clicked
        $(addButton).click(function(){
            //Check maximum number of input fields
            if(x < maxField){
                x++; //Increment field counter
                $(wrapper).append(fieldHTML); //Add field html
            }
            $('.select2').select2({
                'placeholder' : 'choose',
            });
        });
        
        

        //Once remove button is clicked
        $(wrapper).on('click', '.remove_button', function(e){
            e.preventDefault();
            $(this).parent().parent('div').remove(); //Remove field html
            x--; //Decrement field counter
        });
    });
    
     $(document).ready(function(){
            $('.rmv').click(function () {
                var responsible_id = $(this).data('responsible_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"{{route('delete_responsible_question')}}",
                    method:'POST',
                    data: {responsible_id:responsible_id},
                    success:function(data) {
                        $('#responsible_'+ responsible_id).fadeOut('slow');
                    }
                });
            });
        });
</script>
<script>
    $('.editresponsible').click(function () {
        
        var responsible_id = $(this).data('responsible_id');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: '{{route('editresponsible.show')}}',
            method: 'POST',
            data: {
                responsible_id: responsible_id,
            },
            success: function (response) {
                $('#edit_responsibleModal').empty();
                $('.main-content ').append(response.view);
                $('#edit_responsibleModa_'+responsible_id).modal('show');
            }
        });
    });

</script>
@endsection



