@extends('layouts.admin')
<title>{{trans('home.centers')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.centers')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.centers')}}</li>
                </ol>
            </div>
            @can('operations')
            <div class="btn btn-list">
                @can('centers_excel')
                    <a href="#"  data-toggle="modal" data-target="#importcentersmodel">
                        <button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i>     {{__('home.import_centers_excel')}}
                        </button>
                    </a>
                @endcan
                <a class="mr-2" href="{{route('centers.create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> {{trans('home.publish/unpublish')}}</button></a>
                <a class="mr-2" id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
            </div>
            @endcan
        </div>
        <!-- End Page Header -->

        @if(session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.centers')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>

                        <div class="table-responsive">
                       <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th>{{trans('home.id')}}</th>
                                    <th>{{trans('home.name')}}</th>
                                    <th>{{trans('home.partner')}}</th>
                                    <th>{{trans('home.responsible_name')}}</th>
                                    <th>{{trans('home.responsible_email')}}</th>
                                    <th>{{trans('home.responsible_phone')}}</th>
                                    <th>{{trans('home.region')}}</th>
                                    <th>{{trans('home.logo')}}</th>
                                    <th>{{trans('home.status')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($centers as $center)
                                    <tr id="{{$center->id}}">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$center->id}}" /> </td>
                                        <td><a href="{{ route('centers.edit', $center->id) }}">{{$center->id}}</a></td>
                                        <td><a href="{{ route('centers.edit', $center->id) }}">{{$center->{'name_'.$lang} }}</a></td>
                                        <td><a href="{{ route('centers.edit', $center->id) }}">
                                            {{$center->partner?$center->partner->user->name():'Super Admin'}}</a>
                                        </td>
                                        <td><a href="{{ route('centers.edit', $center->id) }}">{{$center->responsible_name}}</a></td>
                                        <td><a href="{{ route('centers.edit', $center->id) }}">{{$center->responsible_email}}</a></td>
                                        <td><a href="{{ route('centers.edit', $center->id) }}">{{$center->responsible_phone}}</a></td>
                                        <td><a href="{{ route('centers.edit', $center->id) }}">{{$center->region?$center->region->{'name_'.$lang}:''}}</a></td>
                                        <td>
                                            <a href="{{ route('centers.edit', $center->id) }}">
                                                @if($center->logo)
                                                    <img style="border-radius:50%" src="{{url('uploads/centers/'.$center->logo)}}" width="70">
                                                @else
                                                    <img style="border-radius:50%" src="{{url('resources/assets/back/img/noimage.png')}}" width="70">
                                                @endif
                                            </a>
                                        </td>
                                        
                                        <td>
                                            <a href="{{ route('centers.edit', $center->id) }}">
                                                @if($center->status == 1)
                                                    <span class="badge badge-success">{{trans('home.yes')}}</span>
                                                @else
                                                    <span class="badge badge-danger">{{trans('home.no')}}</span>
                                                @endif
                                            </a>
                                        </td>                                     
                                        
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        
         <!-- Import Excel  -->
        <div class="modal fade bd-example-modal-lg" id="importcentersmodel" tabindex="-1" role="dialog" aria-labelledby="importcentersmodelTitle" aria-hidden="true">
          <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content" style="border-radius: 35px;">
              <div class="modal-header">
                 <img src="{{url('resources/assets/back/img/centers.PNG')}}">
              </div>
            <form method="post" action="{{ route('center.import.excel') }}" enctype="multipart/form-data">
                  <div class="modal-body ">
                        <div class="m-auto">
                                @csrf
                                <div class="input-group mb-1 d-flex justify-content-center">
                                    <div class="input-group-prepend"> 
                                        <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                    </div>
                                    <div class="custom-file col-8">
                                        <input type="file" class="custom-file-input" name="excelFile"  accept=".csv,.xlsx">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{ trans('home.choose_excel_file') }}</label>
                                    </div>
                                   
                                </div>
                        </div>
                  </div>
                  <div class="modal-footer  justify-content-center ">
                       <button class="btn ripple btn-primary " type="submit"><i
                                    class="fas fa-plus-circle"></i>
                                    {{ trans('home.importExcel') }}</button>
                    <button id="closeModalButton" type="button" class="btn btn-secondary " data-dismiss="modal">Close</button>
                  </div>
            </form>
            </div>
          
          </div>
        </div>
    </div>
@endsection
