@extends('layouts.admin')
<title>{{ __('home.attendances') }} </title>
@section('content')
<style>
    .highlight a.ui-state-default {
      background-color: #ffcccc; /* Example highlight color */
      color: #ff0000; /* Example text color */
    }
    .loader {
      width: fit-content;
      font-weight: bold;
      font-family: sans-serif;
      font-size: 30px;
      /*padding-bottom: 8px;*/
      /*background: linear-gradient(currentColor 0 0) 0 100%/0% 3px no-repeat;*/
      /*animation: l2 2s linear infinite;*/
      position: absolute;
      z-index: 9999;
      width: 100%;
      height: 100%;
      position: fixed;
      left: 0;
      right: 0;
      top: 0;
      bottom: 0;
      text-align: center;
      display: flex;
      align-items: center;
      justify-content: center;
      
    }
    .custom-card .btn-box {
      position: relative;
      top: 22px;
      
    }
    .loader:before {
      content:"";
      width: 100%;
      height: 100%;
      background: #00000050;
      position: absolute;
    }
    @keyframes l2 {to{background-size: 100% 3px}}
  </style>
    <div class="container-fluid">
        <div class="loader" style="display:none"><img src="{{URL::To('resources/assets/back/img/Hourglass.gif')}}"></div> 

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.attendances') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ url('admin/attendances') }}">{{ trans('home.attendances') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $training->{'name_'.$lang} }}</li>
                </ol>
            </div>

            <div class="btn btn-list">
                
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            
            @if(Session::has('error'))
                <div class="alert alert-danger">{{Session::get('error')}}</div>
            @endif
            
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="@if(auth()->user()->type != 'instructor' && auth()->user()->type != 'coordinator' && auth()->user()->type != 'marketer')   @endif row m-3">
                        @can('attendance_and_attachment_control')
                            <div class="col-lg-3 col-sm-12">
                                <label class="">{{trans('home.attendance_date')}}</label>
                                    <div class="input-group">
                                        <input id="attend_date" readonly class="form-control datepicker @error('registration_date') is-invalid @enderror" name="attendance_date"  
                                            placeholder="{{trans('home.attendance_date')}}" required  autocomplete="off">
                                        <div class="input-group-append">
                                            <span class="input-group-text rounded">
                                                <i class="fas fa-calendar"></i>
                                            </span>
                                        </div>
                                    </div>
                            
                                <span class="text-warning"> {{ trans('home.uploading files for same attendance date and same training will overwrite frist one') }}</span>
                            </div>
                            <div class="attendance_btns d-flex col flex-wrap gap-2">
                                <div class=" text-center py-2">
                                    <a class=" btn-box" href="javascript:void;" id="attend_student" ><button class="btn ripple btn-primary">
                                        <i class="fas fa-plus-circle"></i> {{ trans('home.attend_students') }}</button>
                                    </a>
                                </div>
                                
                                <div class=" text-center py-2">
                                    <a class=" btn-box" id="delete_attend"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                                        {{ trans('home.delete_attend') }}</button></a>
                                </div>
                                
                                <div class=" text-center py-2">
                                    <button data-bs-toggle="modal" data-bs-target="#attachmentsmodel" class="btn btn-box ripple btn-info">
                                            <i class="fas fa-trash"></i>
                                            {{ trans('home.attachments') }}
                                        </button>
                                </div>
                            </div>
                            <div class="d-flex col flex-wrap gap-2">
                                @can('attendance_sheet')
                                    <div class="col-lg-3 col-md-3 col-sm-12 text-center py-2">
                                             <a class="mx-5 btn-box" href="{{route('attendanceSheet',$training->id)}}" id="attendance_sheet" ><button class="btn ripple btn-primary">
                                                <i class="fa fa-download"></i> {{ trans('home.attendance_sheet') }}</button></a>
                                    </div>
                                @endcan
                                
                                @can('extract_certificates')
                                    <div class="col-lg-3 col-md-3 col-sm-12 text-center py-2">
                                             <a class="mx-5 btn-box" href="javascript:void;" id="extract_certificates" ><button class="btn ripple btn-primary">
                                                <i class="fa fa-download"></i> {{ trans('home.extract_certificates') }}</button></a>
                                    </div>
                                    
                                    <form id="view_certificate" method="POST" action="{{route('generate_certificates')}}" >
                                        @csrf
                                        <input type="hidden" id="user_ids" name="ids">
                                        <input type="hidden" value="{{$training->id}}" name="training_id">
                                    </form>
                                @endcan
                            </div>
                        @endcan
                      
                    </div>
                    <div class="card-body">
                        <input type="hidden" id="training_id" value="{{$training->id}}">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.trainings') }}</h6>
                            <p class="text-muted card-sub-title">
                            {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>
                        @php $user_c = auth()->user()->roles->pluck('name')->toArray()[0]; @endphp
                        <div class="table-responsive">
                            <table class="table my_tabl" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th >{{ trans('home.ssn') }}</th>
                                        <th >{{ trans('home.phone') }}</th>
                                        <th >{{ trans('home.name') }}</th>
                                        <th >{{ trans('home.training') }}</th>
                                        <th >{{ trans('home.center') }}</th>
                                        <th >{{ trans('home.n_attendance') }}</th>
                                        @can('student_view_certificate') @if($user_c != 'منسق خارجي')<th >{{ trans('home.student_view_certificate') }}</th> @endif @endcan
                                        @can('center_view_certificate') @if($user_c != 'منسق خارجي')<th >{{ trans('home.center_view_certificate') }}</th> @endif @endcan
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($training->students as $student)
                                        <tr id="{{ $student->user->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" value="{{$student->user->id}}" /> </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-training_id="{{$training->id}}" data-user_id="{{$student->user->id}}">
                                                {{ $student->user->id }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-training_id="{{$training->id}}" data-user_id="{{$student->user->id}}">
                                                {{ $student->user->student_info->ssn }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-training_id="{{$training->id}}" data-user_id="{{$student->user->id}}">
                                                {{ $student->user->student_info->mobile }}</a>  </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-training_id="{{$training->id}}" data-user_id="{{$student->user->id}}">
                                                {{ $student->user->name() }}</a> </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-training_id="{{$training->id}}" data-user_id="{{$student->user->id}}">
                                                {{ $training->{'name_'.$lang} }}</a> </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-training_id="{{$training->id}}" data-user_id="{{$student->user->id}}">
                                                {{ $training->trainings_schaduals->center?$training->trainings_schaduals->center->{'name_'.$lang} :'' }}</a> </td>
                                            <td><a href="javascript:void(0);" class="show_detials" data-bs-toggle="modal" data-bs-target="#student_request_modal" data-training_id="{{$training->id}}" data-user_id="{{$student->user->id}}">
                                                {{ count($student->attendance()->where('training_id',$student->training_id)->get()) }}</a> </td>
                                            @can('student_view_certificate')
                                                @if($user_c != 'منسق خارجي')
                                                    <td>
                                                        <label class="custom-switch">
                                                            <input type="checkbox" name="status" value="{{$student->id}}" class="custom-switch-input student_view_certificate" {{ $student->student_view_certificate ? 'checked' : '' }}>
                                                            <span class="custom-switch-indicator"></span>
                                                            <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                                        </label>
                                                    </td> 
                                                @endif
                                            @endcan
                                            @can('center_view_certificate')
                                                @if($user_c != 'منسق خارجي')
                                                    <td>
                                                        <label class="custom-switch">
                                                            <input type="checkbox" name="status" value="{{$student->id}}" class="custom-switch-input center_view_certificate" {{ $student->center_view_certificate ? 'checked' : '' }}>
                                                            <span class="custom-switch-indicator"></span>
                                                            <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                                        </label>
                                                    </td> 
                                                @endif
                                            @endcan
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
					    </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        <div class="modal fade bd-example-modal-lg" id="attachmentsmodel" tabindex="-1" role="dialog" aria-labelledby="attachmentsmodelTitle" aria-hidden="true">
          <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content" style="border-radius: 35px;">
              <div class="modal-header">
                  <h3 class="m-auto text-center"> {{ trans('home.attachments') }} </h3>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
              </div>
              <div class="modal-body ">
                    <div class="m-auto">
                            <div class="input-group mb-1 d-flex justify-content-between">
                                <div class="col-4">
                                     <span> {{ trans('home.attendance_sheet') }}</span>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="attendance_sheet" accept=".pdf,.ppt,.pptx,.doc,.docx,.zip,.xlsx">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{ trans('home.attendance_sheet') }}</label>
                                    </div>
                                </div>
                                <div class="col-4">
                                     <span> {{ trans('home.ownership_rights') }}</span>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="ownership_rights" accept=".pdf,.ppt,.pptx,.doc,.docx,.zip,.xlsx">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{ trans('home.ownership_rights') }}</label>
                                    </div>
                                </div>
                                <div class=" col-4">
                                        <span class="text-danger"> {{ trans('home.only_zip_files') }}</span>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="attachments"  accept=".zip" >
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{ trans('home.attachments') }}</label>
                                    </div>
                                    <br>
                                    <span class="badge badge-warning">({{trans('home.Documentation: Photos and videos')}})</span>
                                </div>
                            </div>
                    </div>
              </div>
              <div class="modal-footer justify-content-center ">
                <button type="button" class="btn btn-secondary " data-bs-dismiss="modal">{{ trans('home.submit_attendance') }}</button>
              </div>
            </div>
          
          </div>
        </div>
    </div>
@endsection
@section('script')
<!--attend _students-->
    <script>
        $(document).ready(function(){
            $('#attend_student').click(function(){
                var id = [];
                $('.tableChecked:checked').each(function(i){
                    id[i] = $(this).val();
                });
                
                if(id.length === 0 ) {
                    alert("Please Select at least one checkbox");
                }
                else if(id.length != 0 && $('#attend_date').val() == '') {
                    alert("Please Select Date");
                }
                else {
                    var attend_date = $('#attend_date').val();
                    var training_id = $('#training_id').val();
                    
                    var formData = new FormData();
                    
                    formData.append('id', id);
                    formData.append('attend_date', attend_date);
                    formData.append('training_id', training_id);
                    
                    var attendance_sheet = $('#attendance_sheet').prop('files');
                    if (attendance_sheet && attendance_sheet.length > 0) {
                        formData.append('attendance_sheet', attendance_sheet[0]);
                    }
                    
                    var ownership_rights = $('#ownership_rights').prop('files');
                    if (ownership_rights && ownership_rights.length > 0) {
                        formData.append('ownership_rights', ownership_rights[0]);
                    }
                    
                    var attachments = $('#attachments').prop('files');
                    if (attachments && attachments.length > 0) {
                        $.each(attachments, function(i, file) {
                            formData.append('attachments', file);
                        });
                    }
        
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url:"<?php echo route('attend_students') ?>",
                        type:'POST',
                        data: formData,
                        processData: false,
                        contentType: false,
                        beforeSend: function() {
                            $('.loader').show();
                        },
                        success:function(data)
                        {
                            location.reload();
                        },
                        error: function(xhr) { // if error occured
                            alert("Error occured.please try again");
                        },
                    });
                }
            });
        });

    </script>
<!--delete attend _students-->
    <script>
        $(document).ready(function(){
            $('#delete_attend').click(function(){
                var id = [];
                $('.tableChecked:checked').each(function(i){
                    id[i] = $(this).val();
                });
                var attend_date = $('#attend_date').val();
                var training_id = $('#training_id').val();
                if(id.length === 0 ) //tell you if the array is empty
                {
                    alert("Please Select at least one checkbox");
                }
                if(attend_date=='') 
                {
                    alert("Please Select Date");
                }
                else
                {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    
                    $.ajax({
                        url:"{{ route('delete_attend') }}",
                        type:'POST',
                        data:{
                            id:id,
                            attend_date:attend_date,
                            training_id:training_id
                        },
                        success:function(data)
                        {
                            
                            location.reload();
                        }
                    });
                }
            });
        });
    </script>
    <!--show detaisl-->
    <script>
        $(document).ready(function(){
            $('.show_detials').click(function () {
            var user_id = $(this).data('user_id');
            var training_id = $(this).data('training_id');
            var modalId = '#student_request_modal_' + user_id;
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                 url:"{{ route('attendance_details') }}",
                method: 'Post',
                data: {
                    user_id: user_id,
                    training_id:training_id},
                success: function (data) {
                    $('body').append(data.view);
                    $(modalId).modal('show');
                    
                },
            });
        });
        });
    </script>
    <!--date picker-->
    
   {{-- <script>
    $(document).ready(function(){
      // Define start and end dates
      var startDate = moment('{{\Carbon\Carbon::parse($training->trainings_schaduals->start_date)->format("Y-m-d")}}'); // Specific start date
      var endDate = moment('{{\Carbon\Carbon::parse($training->trainings_schaduals->end_date)->format("Y-m-d")}}'); // Specific end date

      // Initialize datepicker
      $('.datepicker').datepicker({
        dateFormat: 'yy-mm-dd',
        autoclose: true,
        todayHighlight: true,
        startDate: startDate.toDate(), // Convert moment object to JavaScript Date object
        endDate: endDate.toDate() // Convert moment object to JavaScript Date object
      });
    });
  </script> --}}
  
    <script>
        var startDate = moment('{{\Carbon\Carbon::parse($training->trainings_schaduals->start_date)->format("Y,m,d")}}'); // Specific start date
        var endDate = moment('{{\Carbon\Carbon::parse($training->trainings_schaduals->end_date)->format("Y,m,d")}}'); // Specific end date
      
        $( ".datepicker" ).datepicker({
            minDate: new Date(startDate),
            maxDate: new Date(endDate),
          
            beforeShowDay: function(date) {
                var minDate = new Date(startDate); // Start of disabled interval
                var maxDate = new Date(endDate); // End of disabled interval
                if (date < minDate && date > maxDate) {
                        return [false, 'highlight', 'Disabled']; // Apply 'disabled' class to dates within the interval
                }
                return [true, '']; // Enable all other dates
            }
        });
        // $( ".datepicker" ).datepicker({
        //     changeMonth: true,
        //     changeYear: true,
        //     dateFormat: 'yy-mm-dd'
        // });
        // var enabledDays = @json($enabledDays);
        // $(function() {
        //   $(".datepicker").datepicker({
        //     beforeShowDay: function(date) {
        //     var day = date.getDate();
        //     return [enabledDays.includes(day), ''];
        //     }
        //   });
        // });
        
    </script>
       <!--change view certificate-->
     <script>
        $(document).ready(function() {
            
            $(".student_view_certificate").on("change", function() {
                var user_id = $(this).closest("tr").attr("id");
                var isChecked = $(this).is(":checked") ? 1 : 0;
                var type = 'student';
               $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                $.ajax({
                    url:"<?php echo route('change_view_certificate') ?>",
                    type:'POST',
                    data: {user_id:user_id , view_certificate: isChecked , type: type},
                    success:function(response)
                    {
                        if (response.success) {
                            $.confirm({
                                title: response.message,
                                content:'',
                                buttons: {
                                    cancel: {
                                        text: '{{__('home.done')}}',
                                        btnClass: 'm-auto btn-success any-other-class',
                                        action: function(){
                                            close();
                                        }
                                    }
                                }
                            });
                        }
                    }
                });
            });
            
            
            $(".center_view_certificate").on("change", function() {
                var user_id = $(this).closest("tr").attr("id");
                var isChecked = $(this).is(":checked") ? 1 : 0;
                var type = 'center';
               $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                $.ajax({
                    url:"<?php echo route('change_view_certificate') ?>",
                    type:'POST',
                    data: {user_id:user_id , view_certificate: isChecked, type: type},
                    success:function(response)
                    {
                        if (response.success) {
                        $.confirm({
                            title: response.message,
                            content:'',
                            buttons: {
                                cancel: {
                                    text: '{{__('home.done')}}',
                                    btnClass: 'm-auto btn-success any-other-class',
                                    action: function(){
                                        close();
                                    }
                                }
                            }
                        });
                        }
                    }
                });
            });
            
        });
    </script>
    <!--extract certificates-->
   <script>
       $(document).ready(function(){
        var form = document.getElementById("view_certificate");
            document.getElementById("extract_certificates").addEventListener("click", function () {
                var id = [];
                $('.tableChecked:checked').each(function(i){
                    id[i] = $(this).val();
                });
                if(id.length === 0 ) //tell you if the array is empty
                {
                    alert("Please Select at least one    checkbox");
                }
                else
                {
                    $('#user_ids').val(id);
                    form.submit();
                }
        });
            
        // var attendance_sheet_form = document.getElementById("attendance_sheet");
        //     document.getElementById("attendance_sheet").addEventListener("click", function () {
        //             form.submit();
        //         }
        // });
      });
   
    </script>

@endsection