@extends('layouts.admin')
<title>{{ trans('home.attendances') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
      
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.attendances') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.attendances') }}</li>
                </ol>
            </div>
        </div>
      

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.students') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                    <!--<th>{{trans('home.id')}}</th>-->
                                    <th>{{trans('home.code')}}</th>
                                    <th>{{trans('home.name_ar')}}</th>
                                    <th>{{trans('home.partner')}}</th>
                                    <th>{{trans('home.overall_days')}}</th>
                                    <th>{{trans('home.overall_time')}}</th>
                                    <th>{{trans('home.timing_type')}}</th>
                                    <th>{{trans('home.training_date_from')}}</th>
                                    <th>{{trans('home.training_date_to')}}</th>
                                    <th>{{trans('home.training_status')}}</th>
                                    <th>{{trans('home.n_students')}}</th>
                                    <th>{{trans('home.certified_std_ratio')}}</th>
                                    <th>{{trans('home.export_attendance_sheet')}}</th>
                                    <th>{{trans('home.attachments')}}</th>
                                    <th>{{trans('home.status')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($trainings as $training)
                                    <tr id="{{$training->id}}">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$training->id}}" /> </td>
                                        {{--<td><a href="{{ route('attendances.show', $training->id) }}">{{$training->id}}</a></td>--}}
                                        <td><a href="{{ route('attendances.show', $training->id) }}">{{$training->code}}</a></td>
                                        <td><a href="{{ route('attendances.show', $training->id) }}">{{$training->name_ar}}</a></td>
                                        <td>{{ $training->trainings_schaduals->center->{'name_'.$lang} ?? '' }}</td>
                                        <td>{{$training->overall_days}}</td>
                                        <td>{{$training->overall_time}}</td>
                                        <td>{{$training->timing_type}}</td>
                                        <td><a>
                                            {{isset($training->trainings_schaduals->start_date) ? \Carbon\Carbon::parse($training->trainings_schaduals->start_date)->format("Y-m-d") : ''  }}
                                           </a></td>
                                        <td><a>
                                            {{isset($training->trainings_schaduals->end_date) ? \Carbon\Carbon::parse($training->trainings_schaduals->end_date)->format("Y-m-d") : ''  }}
                                            </a></td>
                                        <td>
                                                @if($training->training_status == '-1') 
                                                     <h4 class="d-flex justify-content-center mt-4 badge badge-pill badge-danger">{{trans('home.no_date_found')}}</h4>
                                                @elseif($training->training_status == '0') 
                                                     <h4 class="d-flex justify-content-center mt-4 badge badge-pill badge-primary">{{trans('home.not_started') }}</h4>
                                                
                                                @elseif($training->training_status == '1') 
                                                     <h4 class="d-flex justify-content-center mt-4 badge badge-pill badge-success">{{ trans('home.started') }}</h4>
                                                
                                                @elseif($training->training_status == '2') 
                                                    <h4 class="d-flex justify-content-center mt-4 badge badge-pill badge-warning">{{ trans('home.finished') }}</h4>
                                                @endif
                                                
                                        </td>
                                        <td>
                                            <div>
                                                <a class="text-info" href="{{ route('students_per_training', ['training_id'=>$training->id]) }}">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </div>
                                            <div>{{ count($training->students) }}</div>
                                        </td>
                                        @php
                                            $students = $training->students->filter(function($student) {
                                                return count($student->attendance) >= 3;
                                            })->where('view_certifiacte',1);
                                        @endphp
                                        
                                        <td>
                                            <div class="progress-bar bg-success {{(count($training->students) > 0) ? number_format((float)((count($students)/count($training->students)) * 100), 2, '.', '') <= 25 ? 'text-black' : '' : 'text-black'}}" role="progressbar" style="width: {{ (count($training->students) > 0) ? number_format((float)((count($students)/count($training->students)) * 100), 2, '.', '') : 0 }}%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                {{ (count($training->students) > 0) ? number_format((float)((count($students)/count($training->students)) * 100), 2, '.', '') : 0 }}%
                                            </div>
                                        </td>
                                        <td>
                                            <form id="attendance_form" method="POST" action="{{route('export-attendance')}}">
                                                @csrf
                                                <input type="hidden" value="{{$training->id}}" name="id" >
                                                <button type="submit" style="border: none; background: none;">
                                                    <i class="fas fa-download"></i>
                                                </button>
                                            </form>
                                        </td>
                                        <td>
                                            <a href="javascript:void(0);" class="show_attachments" data-bs-toggle="modal" 
                                                data-bs-target="#attachments_modal" data-training_id="{{$training->id}}">
                                                {{trans('home.attachments')." : ".$training->training_attachments_count()}}
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-file-text">
                                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                                    <polyline points="14 2 14 8 20 8"></polyline>
                                                    <line x1="16" y1="13" x2="8" y2="13"></line>
                                                    <line x1="16" y1="17" x2="8" y2="17"></line>
                                                    <polyline points="10 9 9 9 8 9"></polyline>
                                                  </svg>
                                            </a>
                                        </td>
                                        <td>
                                            <a>
                                                @if($training->status == 1)
                                                    <span class="badge badge-success">{{trans('home.yes')}}</span>
                                                @else
                                                    <span class="badge badge-danger">{{trans('home.no')}}</span>
                                                @endif
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
    <script>
        $('.show_attachments').click(function () {
                console.log('asda');
                var training_id = $(this).data('training_id');
                var modalId = '#show_attachments_modal_' + training_id;
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"{{ route('attendance_attachments') }}",
                    method: 'Post',
                    data: {
                        training_id:training_id},
                    success: function (data) {
                        console.log(data);
                        $('body').append(data.view);
                        $(modalId).modal('show');
                    },
                });
            });
    </script>
    
    
    <script>

    // <script>
    //     $(document).ready(function(){
    //         $('.show_request').click(function () {
    //         var request_id = $(this).data('request_id');
    //         var modalId = '#student_request_modal_' + request_id;
    //         $.ajaxSetup({
    //             headers: {
    //                 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    //             }
    //         });
    //         var path = "student_requests//show"
    //         var fieldHTML ='<span class="badge badge-info">{{__('home.seen')}}</span>';
                
    //         $.ajax({
    //             url: "student_requests/"+request_id+"/show",
    //             method: 'Get',
    //             data: {request_id: request_id},
    //             success: function (data) {
    //                 $('#status_'+request_id).html(fieldHTML);
    //                 $('body').append(data.view);
    //                 $(modalId).modal('show');
                    
    //             },
    //         });
    //     });
    //     });
    //</script>
@endsection