@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_address')}}</title>
@endsection
@section('content')

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.addresses')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/addresses')}}">{{trans('home.addresses')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_address')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    {!! Form::open(['method'=>'PATCH','url' => 'admin/addresses/'.$address->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.edit_address')}}</h6>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.address_name_en')}}</label>
                                <input class="form-control" name="address_name_en" type="text" placeholder="{{trans('home.address_name_en')}}"  value="{{$address->address_name_en}}" required>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.address_en')}}</label>
                                <input class="form-control" name="address_en" type="text" placeholder="{{trans('home.address_en')}}"  value="{{$address->address_en}}" required>
                            </div>

                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.address_name_ar')}}</label>
                                <input class="form-control" name="address_name_ar" type="text" placeholder="{{trans('home.address_name_ar')}}" value="{{$address->address_name_ar}}" >
                            </div>
                            
                             <div class="form-group col-md-4">
                                <label class="">{{trans('home.address_ar')}}</label>
                                <input class="form-control" name="address_ar" type="text" placeholder="{{trans('home.address_ar')}}" required value="{{$address->address_ar}}" >
                            </div>

                            <div class="col-md-6">
                                <label>{{trans('home.iframe_map_url')}}</label>
                                <textarea class="form-control" name="iframe_map_url" type="text" placeholder="{{trans('home.iframe_map_url')}}">{{$address->iframe_map_url}}</textarea>
                            </div>
                            
                            <div class="col-md-6">
                                <label>{{trans('home.share_map_url')}}</label>
                                <textarea class="form-control" name="share_map_url" type="text" placeholder="{{trans('home.share_map_url')}}">{{$address->share_map_url}}</textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2">{{trans('home.publish')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input" {{($address->status == 1)? 'checked':''}}>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin/addresses')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

    {!! Form::close() !!}

</div>

@endsection
