@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_aboutStrucs')}}</title>
@endsection
@section('content')

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.aboutStrucs')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/aboutStrucs')}}">{{trans('home.aboutStrucs')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_aboutStruc')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    {!! Form::open(['method'=>'PATCH','url' => 'admin/aboutStrucs/'.$aboutStruc->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.edit_aboutStruc')}}</h6>
                            <hr>
                        </div>    
                        <div class="row">

                            <div class="form-group col-md-3">
                                <label class= "">{{trans('home.title_en')}}</label>
                                <input class="form-control" name="title_en" type="text" placeholder="{{trans('home.title_en')}}" value="{{$aboutStruc->title_en}}">
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class= "">{{trans('home.title_ar')}}</label>
                                <input class="form-control" name="title_ar" type="text" placeholder="{{trans('home.title_ar')}}" value="{{$aboutStruc->title_ar}}">
                            </div>


                            <div class="form-group  col-md-4">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class= "">{{trans('home.alt_img')}}</label>
                                <input class="form-control" name="alt_img" type="text" placeholder="{{trans('home.alt_img')}}" value="{{$aboutStruc->alt_img}}">
                            </div>


                            @if($aboutStruc->image)
                                <div class="form-group  col-md-12">
                                    <img style="border-radius:50%" src="{{url('uploads/aboutStrucs/'.$aboutStruc->image)}}" width="120">
                                </div>
                            @endif

                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.text_en')}}</label>
                                <textarea class="form-control area1" name="text_en"  placeholder="{{trans('home.text_en')}}">{!! $aboutStruc->text_en !!}</textarea>
                            </div>
                            
                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.text_ar')}}</label>
                                <textarea class="form-control area1" name="text_ar"  placeholder="{{trans('home.text_ar')}}">{!! $aboutStruc->text_ar !!}</textarea>
                            </div>


                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2">{{trans('home.publish')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input" {{($aboutStruc->status == 1)? 'checked':''}}>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                </label>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin/aboutStrucs')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    {!! Form::close() !!}
</div>

@endsection
