@extends('layouts.admin')
<title>{{trans('home.aboutStrucs')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.aboutStrucs')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.aboutStrucs')}}</li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="{{url('admin/aboutStrucs/create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
                <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> {{trans('home.publish/unpublish')}}</button></a>
                <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.aboutStrucs')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll" class="tableChecked" name="checkbox" /></th>
                                    <th>{{trans('home.id')}}</th>
                                    <th>{{trans('home.title_en')}}</th>
                                    <th>{{trans('home.title_ar')}}</th>
                                    <th>{{trans('home.image')}}</th>
                                    <th>{{trans('home.status')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($aboutStrucs as $aboutStruc)
                                    <tr id="{{$aboutStruc->id}}">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$aboutStruc->id}}" /></td>
                                        <td><a href="{{ route('aboutStrucs.edit', $aboutStruc->id) }}">{{$aboutStruc->id}}</a></td>
                                        <td><a href="{{ route('aboutStrucs.edit', $aboutStruc->id) }}">{{$aboutStruc->title_en}}</a></td>
                                        <td><a href="{{ route('aboutStrucs.edit', $aboutStruc->id) }}">{{$aboutStruc->title_ar}}</a></td>
                                        <td>
                                            <a href="{{ route('aboutStrucs.edit', $aboutStruc->id) }}">
                                                @if($aboutStruc->image)
                                                    <img style="border-radius:50%" src="{{url('/uploads/aboutStrucs')}}/{{$aboutStruc->image}}" width="70">
                                                @else
                                                    <img style="border-radius:50%" src="{{url('resources/assets/back/img/noimage.png')}}" width="70">
                                                @endif
                                            </a>
                                        </td>
                                        
                                        <td>
                                            <a href="{{ route('aboutStrucs.edit', $aboutStruc->id) }}">
                                                @if($aboutStruc->status == 1)
                                                    <span class="badge badge-success">{{trans('home.yes')}}</span>
                                                @else
                                                    <span class="badge badge-danger">{{trans('home.no')}}</span>
                                                @endif
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                </div>

                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
