@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_about')}}</title>
@endsection
@section('content')

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.about')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/about')}}">{{trans('home.about')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_about')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    {!! Form::open(['method'=>'PATCH','route' => 'admin.about.update', 'data-toggle'=>'validator', 'files'=>'true']) !!}

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title ">{{trans('home.edit_about')}}</h6>
                            <hr>
                        </div>
                        
                        <div class="row">
                            <div class="form-group col-md-3"> 
                                <label for="title_en">{{trans('home.title_en')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.title_en')}}" name="title_en" value="{{$about->title_en}}">
                            </div>

                            <div class="form-group col-md-3 ">     
                                <label for="title_ar">{{trans('home.title_ar')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.title_ar')}}" name="title_ar" value="{{$about->title_ar}}">
                            </div>

                            <div class="form-group col-md-3">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-2"> 
                                <label for="alt_img">{{trans('home.alt_img')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.alt_img')}}" name="alt_img" value="{{$about->alt_img}}">
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label>{{trans('home.banner')}}</label>
                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="banner">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_banner')}}</label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-2"> 
                                <label for="alt_banner">{{trans('home.alt_banner')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.alt_banner')}}" name="alt_banner" value="{{$about->alt_banner}}">
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label>{{trans('home.profile_file')}}</label>
                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="profile">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_profile')}}</label>
                                    </div>
                                </div>
                            </div>

                           
                            <div class="form-group col-md-6">
                                @if($about->image)
                                    <img src="{{url('uploads/aboutStrucs/'.$about->image)}}" width="150">
                                @endif
                            </div>
                            
                            <div class="form-group col-md-6">
                                @if($about->banner)
                                    <img src="{{url('uploads/aboutStrucs/.$about->banner')}}" width="150">
                                @endif
                            </div>
                            <br>
                            
                            <div class="form-group col-md-6 ">    
                                <label for="text_en">{{trans('home.text_en')}}</label>
                                <textarea class="form-control area1" placeholder="{{trans('home.text_en')}}" name="text_en">{!!$about->text_en!!}</textarea>
                            </div>

                            <div class="form-group col-md-6 ">    
                                <label for="text_ar">{{trans('home.text_ar')}}</label>
                                <textarea class="form-control area1" placeholder="{{trans('home.text_ar')}}" name="text_ar">{!!$about->text_ar!!}</textarea>
                            </div>
                            
                            

                           {{-- <div class="form-group col-md-12">
                                <p class="mt-4 mb-2">{{trans('home.view_why_us_section')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" value="0" class="custom-switch-input show-why-us" @if($about->why_us_title_en) checked @endif>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_view_why_us_section')}}</span>
                                </label>
                            </div> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        <!-- Row-->
        <div class="row" id="why-us" @if($about->why_us_title_en) style="display:block;" @else style="display:none;" @endif> 
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title ">{{trans('home.why_us')}}</h6>
                        </div>
                        
                        <div class="row">
                            <div class="form-group col-md-6"> 
                                <label for="why_us_title_en">{{trans('home.why_us_title_en')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.why_us_title_en')}}" name="why_us_title_en" value="{{$about->why_us_title_en}}">
                            </div>

                            <div class="form-group col-md-6 ">     
                                <label for="why_us_title_ar">{{trans('home.why_us_title_ar')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.why_us_title_ar')}}" name="why_us_title_ar" value="{{$about->why_us_title_ar}}">
                            </div>
                            

                            <div class="form-group col-md-6 ">    
                                <fieldset class="form-group">
                                    <label for="why_us_text_en">{{trans('home.why_us_text_en')}}</label>
                                    <textarea class="form-control area1" placeholder="{{trans('home.why_us_text_en')}}" name="why_us_text_en">{!!$about->why_us_text_en!!}</textarea>
                                </fieldset>
                            </div>

                            <div class="form-group col-md-6 ">    
                                <fieldset class="form-group">
                                    <label for="why_us_text_ar">{{trans('home.why_us_text_ar')}}</label>
                                    <textarea class="form-control area1" placeholder="{{trans('home.why_us_text_ar')}}" name="why_us_text_ar">{!!$about->why_us_text_ar!!}</textarea>
                                </fieldset>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    {!! Form::close() !!}
</div>

@endsection

@section('script')
    <script>
        //////////// dispaly why us section /////////
        $(".show-why-us").click(function(){
            if($(".show-why-us").is(':checked') ){
                $("#why-us").removeAttr( "style" );
            }else{
                $("#why-us").css({'display': 'none'});
            }
        });
    </script>    
@endsection