<?php
namespace App\Traits;
use App\Models\Brand;
use App\Models\SeoAssistant;
use App\Models\Setting;
use App\Models\Configration;
use Melbahja\Seo\Schema;
use Melbahja\Seo\Schema\Thing;
use Melbahja\Seo\MetaTags;
use App\Models\About;
use App\Models\Faq;
use App\Models\BlogItem;
use App\Models\NewsItem;
use App\Models\Training;
use App\Models\Service;
use App\Models\Project;
use \Mcamara\LaravelLocalization\Facades\LaravelLocalization;

trait SeoTrait {

    public function homePageSeo(){
        $lang=\LaravelLocalization::getCurrentLocale();
        $seo = SeoAssistant::first();
        $setting = Setting::first();
        $configration = Configration::where('lang',$lang)->first();
    

        // $schema1 = new Thing('LocalBusiness', [
        //     'name'          => $configration->app_name,
        //     'url'          => LaravelLocalization::localizeUrl('/'),
        //     'image'         => url("uploads/settings/source/$configration->app_logo"),
        //     'telephone' => $setting->mobile,
        //     'address' => $configration->address1,
        // ]);


        $schema2= new Thing('Organization', [
            'url'          => LaravelLocalization::localizeUrl('/'),
            'logo'         => url("uploads/settings/source/$configration->app_logo"),
            'contactPoint' => new Thing('ContactPoint', [
                'telephone' => $setting->mobile,
                'contactType' => 'customer service'
            ]),
        ]);

        $schema = new Schema(
            // $schema1,
            $schema2
        );
        $metatags = new MetaTags();
        $metatags
                ->title(($seo->home_meta_title || $seo->home_meta_title_ar)?($lang=='en' ? $seo->home_meta_title ?? '' : $seo->home_meta_title_ar ?? ''):$configration->app_name)
                ->meta('title',($seo->home_meta_title || $seo->home_meta_title_ar)?($lang=='en' ? $seo->home_meta_title ?? '' : $seo->home_meta_title_ar ?? ''):$configration->app_name)
                ->description(($seo->home_meta_desc || $seo->home_meta_desc_ar)?($lang=='en' ? $seo->home_meta_desc ?? '' : $seo->home_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                ->meta('author',$configration->app_name)
                ->meta('time',date('D M j G:i:s T Y', strtotime($seo->updated_at)))
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl('/'))
                ->canonical(LaravelLocalization::localizeUrl('/'))
                ->shortlink(LaravelLocalization::localizeUrl('/'))
                ->meta('robots',($seo->home_meta_robots)?'index':'noindex');

        return [$schema,$metatags];
    }

    public function aboutUsPageSeo(){
        $about = About::first();
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $setting = Setting::first();
        $seo = SeoAssistant::first();

        $metatags = new MetaTags();
        $metatags
                ->title(($seo->about_meta_title)? $seo->about_meta_title ?? '' :$about->title_ar ?? '')
                ->meta('title',($seo->about_meta_title)? $seo->about_meta_title ?? '' :$about->title_ar ?? '')
                ->description(($seo->about_meta_desc)?$seo->about_meta_desc ?? '':(($lang == 'en')?strip_tags($about->text_en ?? ''):strip_tags($about->text_ar ?? '')))
                ->meta('author',$configration->app_name)
                ->meta('time',date('D M j G:i:s T Y', strtotime($about->updated_at)))
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl('/about-us'))
                ->canonical(LaravelLocalization::localizeUrl('/about-us'))
                ->shortlink(LaravelLocalization::localizeUrl('/about-us'))
                ->meta('robots',($seo->about_meta_robots)?'index':'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url'=> LaravelLocalization::localizeUrl("/about-us"),
                'image'=> url("uploads/settings/source/$configration->app_logo"),
                'headline'=> ($seo->about_meta_title)?$seo->about_meta_title ?? '':(($lang == 'en')?$about->title_en ?? '':$about->title_ar ?? ''),
                'author' => new Thing('author', [
                    'name'=>$configration->app_name,
                    'url'=> LaravelLocalization::localizeUrl("/about-us"),
                ]),

                'datePublished'=> $about->crated_at,
                'dateModified'=> $about->updated_at,
            ])
        );
        return [$schema,$metatags];
    }

    public function contactUsPageSeo(){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $setting = Setting::first();
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
                ->title(($seo->contact_meta_title || $seo->contact_meta_title_ar)?($lang=='en' ? $seo->contact_meta_title ?? '' : $seo->contact_meta_title_ar ?? ''):$configration->app_name)
                ->meta('title',(($seo->contact_meta_title || $seo->contact_meta_title_ar)?($lang=='en' ? $seo->contact_meta_title ?? '' : $seo->contact_meta_title_ar ?? ''):$configration->app_name))
                ->description(($seo->contact_meta_desc || $seo->contact_meta_desc_ar)?($lang=='en' ? $seo->contact_meta_desc ?? '' : $seo->contact_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                ->meta('author',$configration->app_name)
                ->meta('time',date('D M j G:i:s T Y', strtotime($seo->updated_at)))
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl('/contact-us'))
                ->canonical(LaravelLocalization::localizeUrl('/contact-us'))
                ->shortlink(LaravelLocalization::localizeUrl('/contact-us'))
                ->meta('robots',($seo->contact_meta_robots)?'index':'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url'=> LaravelLocalization::localizeUrl("/contact-us"),
                'image'=> url("uploads/settings/source/$configration->app_logo"),
                'headline'=> ($seo->contact_meta_title)?$seo->contact_meta_title:$configration->app_name,
                'author' => new Thing('author', [
                    'name'=>$configration->app_name,
                    'url'=> LaravelLocalization::localizeUrl("/contact-us"),
                ]),
            ])
        );
        return [$schema,$metatags];
    }

    public function blogsPageSeo(){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $setting = Setting::first();
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
                ->title(($seo->blogs_meta_title||$seo->blogs_meta_title_ar)?(($lang == 'en')?$seo->blogs_meta_title ?? '':$seo->blogs_meta_title_ar ?? ''):$configration->app_name)
                ->meta('title',($seo->blogs_meta_title||$seo->blogs_meta_title_ar)?(($lang == 'en')?$seo->blogs_meta_title ?? '':$seo->blogs_meta_title_ar ?? ''):$configration->app_name)
                ->description(($seo->blogs_meta_desc||$seo->blogs_meta_desc_ar)?(($lang == 'en')?$seo->blogs_meta_desc ?? '':$seo->blogs_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                ->meta('author',$configration->app_name)
                ->meta('time',date('D M j G:i:s T Y', strtotime($seo->updated_at)))
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl('/blogs'))
                ->canonical(LaravelLocalization::localizeUrl('/blogs'))
                ->shortlink(LaravelLocalization::localizeUrl('/blogs'))
                ->meta('robots',($seo->blogs_meta_robots)?'index':'noindex');
            
        return [$metatags];
    }

    public function newsPageSeo(){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $setting = Setting::first();
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
                ->title(($seo->news_meta_title||$seo->news_meta_title_ar)?(($lang == 'en')?$seo->news_meta_title ?? '':$seo->news_meta_title_ar ?? ''):$configration->app_name)
                ->meta('title',($seo->news_meta_title||$seo->news_meta_title_ar)?(($lang == 'en')?$seo->news_meta_title ?? '':$seo->news_meta_title_ar ?? ''):$configration->app_name)
                ->description(($seo->news_meta_desc||$seo->news_meta_desc_ar)?(($lang == 'en')?$seo->news_meta_desc ?? '':$seo->news_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                ->meta('author',$configration->app_name)
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl('/news'))
                ->canonical(LaravelLocalization::localizeUrl('/news'))
                ->shortlink(LaravelLocalization::localizeUrl('/news'))
                ->meta('robots',($seo->news_meta_robots)?'index':'noindex');

        return [$metatags];
    }

    public function CategoryBlogsPageSeo($link){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $setting = Setting::first();
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();
        
        $metatags
                ->title(($seo->blogs_meta_title||$seo->blogs_meta_title_ar)?(($lang == 'en')?$seo->blogs_meta_title ?? '':$seo->blogs_meta_title_ar ?? ''):$configration->app_name)
                ->meta('title',($seo->blogs_meta_title||$seo->blogs_meta_title_ar)?(($lang == 'en')?$seo->blogs_meta_title ?? '':$seo->blogs_meta_title_ar ?? ''):$configration->app_name)
                ->description(($seo->blogs_meta_desc||$seo->blogs_meta_desc_ar)?(($lang == 'en')?$seo->blogs_meta_desc ?? '':$seo->blogs_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                ->meta('author',$configration->app_name)
                ->meta('time',date('D M j G:i:s T Y', strtotime($seo->updated_at)))
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl('/blogs/'.$link))
                ->canonical(LaravelLocalization::localizeUrl('/blogs/'.$link))
                ->shortlink(LaravelLocalization::localizeUrl('/blogs/'.$link))
                ->meta('robots',($seo->blogs_meta_robots)?'index':'noindex');

        return [$metatags];
    }
    
    public function FieldPageSeo($link){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $setting = Setting::first();
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
                ->title(($seo->fields_meta_title)?$seo->fields_meta_title ?? '':$configration->app_name)
                ->meta('title',($seo->fields_meta_title)?$seo->fields_meta_title ?? '':$configration->app_name)
                ->description(($seo->fields_meta_desc)?$seo->fields_meta_desc ?? '':strip_tags($configration->about_app))
                ->meta('author',$configration->app_name)
                ->meta('time',date('D M j G:i:s T Y', strtotime($seo->updated_at)))
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl('field/'.$link . '/trainings'))
                ->canonical(LaravelLocalization::localizeUrl('field/'.$link . '/trainings'))
                ->shortlink(LaravelLocalization::localizeUrl('field/'.$link . '/trainings'))
                ->meta('robots',($seo->fields_meta_robots)?'index':'noindex');

        return [$metatags];
    }

    public function brandSeo($link){
        $lang=\LaravelLocalization::getCurrentLocale();
        $brand = Brand::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $configration = Configration::where('lang',$lang)->first();
        $metatags = new MetaTags();
        $metatags
                ->title(($brand->meta_title_en || $brand->meta_title_ar)?(($lang == 'en')? $brand->meta_title_en ?? '' : $brand->meta_title_ar ?? '') : (($lang == 'en')?$brand->name_en ?? '':$brand->name_ar ?? ''))
                ->meta('title',($brand->meta_title_en || $brand->meta_title_ar)?(($lang == 'en')? $brand->meta_title_en ?? '' : $brand->meta_title_ar ?? '') : (($lang == 'en')?$brand->name_en ?? '':$brand->name_ar ?? ''))
                ->description(($brand->meta_desc_en || $brand->meta_desc_ar)?(($lang == 'en')? strip_tags(mb_strimwidth($brand->meta_desc_en ?? '', 0, 150, "...")) : strip_tags(mb_strimwidth($brand->meta_desc_ar ?? '', 0, 150, "..."))):(($brand == 'en')?strip_tags(mb_strimwidth($brand->text_en ?? '', 0, 150, "...")):strip_tags(mb_strimwidth($brand->text_ar ?? '', 0, 150, "..."))))
                ->meta('author',$configration->app_name)
                ->meta('time',date('D M j G:i:s T Y', strtotime($brand->updated_at)))
                ->image(url("uploads/blogitems/source/$brand->image"))
                ->mobile(LaravelLocalization::localizeUrl("blog/" .$link))
                ->canonical(LaravelLocalization::localizeUrl("blog/" .$link))
                ->shortlink(LaravelLocalization::localizeUrl("blog/" .$link))
                ->meta('robots',($brand->meta_robots)?'index':'noindex');

        $schema1 = new Thing('Article', [
            'url'=> LaravelLocalization::localizeUrl("brand/" .$link),
            'image'=> url("uploads/brands/source/$brand->image"),
            'headline'=>($lang == 'en')?$brand->name_en:$brand->name_ar,

            'datePublished'=> $brand->crated_at,
            'dateModified'=> $brand->updated_at,
        ]);


        $schema = new Schema(
            $schema1
        );

        return [$schema,$metatags];
    }

    public function brandsPageSeo(){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $setting = Setting::first();
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
            ->title(($seo->brands_meta_title||$seo->brands_meta_title_ar)?(($lang == 'en')?$seo->brands_meta_title ?? '':$seo->brands_meta_title_ar ?? ''):$configration->app_name)
            ->meta('title',($seo->brands_meta_title||$seo->brands_meta_title_ar)?(($lang == 'en')?$seo->brands_meta_title ?? '':$seo->brands_meta_title_ar ?? ''):$configration->app_name)
            ->description(($seo->brands_meta_desc||$seo->brands_meta_desc_ar)?(($lang == 'en')?$seo->brands_meta_desc ?? '':$seo->brands_meta_desc_ar ?? ''):strip_tags($configration->about_app))
            ->meta('author',$configration->app_name)
            ->image(url("uploads/settings/source/$configration->app_logo"))
            ->mobile(LaravelLocalization::localizeUrl('/brands'))
            ->canonical(LaravelLocalization::localizeUrl('/brands'))
            ->shortlink(LaravelLocalization::localizeUrl('/brands'))
            ->meta('robots',($seo->brands_meta_robots)?'index':'noindex');

        return [$metatags];
    }
    public function blogSeo($link){
        $lang=\LaravelLocalization::getCurrentLocale();
        $blog = BlogItem::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $configration = Configration::where('lang',$lang)->first();
        $metatags = new MetaTags();
        $metatags
            ->title(($blog->meta_title_en || $blog->meta_title_ar)?(($lang == 'en')? $blog->meta_title_en ?? '' : $blog->meta_title_ar ?? '') : (($lang == 'en')?$blog->title_en:$blog->title_ar))
            ->meta('title',($blog->meta_title_en || $blog->meta_title_ar)?(($lang == 'en')? $blog->meta_title_en ?? '' : $blog->meta_title_ar ?? '') : (($lang == 'en')?$blog->title_en:$blog->title_ar))
            ->description(($blog->meta_desc_en || $blog->meta_desc_ar)?(($lang == 'en')? strip_tags(mb_strimwidth($blog->meta_desc_en, 0, 150, "...")) : strip_tags(mb_strimwidth($blog->meta_desc_ar, 0, 150, "..."))):(($blog == 'en')?strip_tags(mb_strimwidth($blog->text_en, 0, 150, "...")):strip_tags(mb_strimwidth($blog->text_ar, 0, 150, "..."))))
            ->meta('author',$configration->app_name)
            ->meta('time',date('D M j G:i:s T Y', strtotime($blog->updated_at)))
            ->image(url("uploads/blogitems/source/$blog->image"))
            ->mobile(LaravelLocalization::localizeUrl("blog/" .$link))
            ->canonical(LaravelLocalization::localizeUrl("blog/" .$link))
            ->shortlink(LaravelLocalization::localizeUrl("blog/" .$link))
            ->meta('robots',($blog->meta_robots)?'index':'noindex');

        $schema1 = new Thing('Article', [
            'url' => LaravelLocalization::localizeUrl("blog/" . $link),
            'image' => url("uploads/blogitems/$blog->image"),
            'headline' => ($lang == 'en') ? $blog->meta_title_en : $blog->meta_title_ar,
            'datePublished' => $blog->updated_at->toIso8601String(), // Format date properly
            'dateModified' => $blog->updated_at->toIso8601String(),
            'description' => ($lang == 'en') ? $blog->meta_desc_en : $blog->meta_desc_ar,
            'author' => [
                '@type' => 'Person',
                'name' => $configration->app_name
            ],
            'publisher' => [
                '@type' => 'Organization',
                'name' => $configration->app_name
            ],
        ]);


        $schema = new Schema(
            $schema1
        );

        return [$schema,$metatags];
    }
    
    public function newsSeo($link){
        $lang=\LaravelLocalization::getCurrentLocale();
        $news = NewsItem::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $configration = Configration::where('lang',$lang)->first();
        $metatags = new MetaTags();
        $metatags
            ->title(($news->meta_title_en || $news->meta_title_ar)?(($lang == 'en')? $news->meta_title_en ?? '' : $news->meta_title_ar ?? '') : (($lang == 'en')?$news->title_en:$news->title_ar))
            ->meta('title',($news->meta_title_en || $news->meta_title_ar)?(($lang == 'en')? $news->meta_title_en ?? '' : $news->meta_title_ar ?? '') : (($lang == 'en')?$news->title_en:$news->title_ar))
            ->description(($news->meta_desc_en || $news->meta_desc_ar)?(($lang == 'en')? strip_tags(mb_strimwidth($news->meta_desc_en, 0, 150, "...")) : strip_tags(mb_strimwidth($news->meta_desc_ar, 0, 150, "..."))):(($news == 'en')?strip_tags(mb_strimwidth($news->text_en, 0, 150, "...")):strip_tags(mb_strimwidth($news->text_ar, 0, 150, "..."))))
            ->meta('author',$configration->app_name)
            ->meta('time',date('D M j G:i:s T Y', strtotime($news->updated_at)))
            ->image(url("uploads/newsitems/source/$news->image"))
            ->mobile(LaravelLocalization::localizeUrl("new/" .$link))
            ->canonical(LaravelLocalization::localizeUrl("new/" .$link))
            ->shortlink(LaravelLocalization::localizeUrl("new/" .$link))
            ->meta('robots',($news->meta_robots)?'index':'noindex');
            
        return [$metatags];
    }
    
    public function courseSeo($link){
        $lang=\LaravelLocalization::getCurrentLocale();
        $course = Training::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $configration = Configration::where('lang',$lang)->first();
        $metatags = new MetaTags();
        $metatags
            ->title(($course->meta_title_en || $course->meta_title_ar)?(($lang == 'en')? $course->meta_title_en ?? '' : $course->meta_title_ar ?? '') : (($lang == 'en')?$course->title_ar ?? '':$course->link_ar ?? ''))
            ->meta('title',($course->meta_title_en || $course->meta_title_ar)?(($lang == 'en')? $course->meta_title_en ?? '' : $course->meta_title_ar ?? '') : (($lang == 'en')?$course->link_en:$course->link_ar))
            ->description(($course->meta_desc_en || $course->meta_desc_ar)?(($lang == 'en')? strip_tags(mb_strimwidth($course->meta_desc_en, 0, 150, "...")) : strip_tags(mb_strimwidth($course->meta_desc_ar, 0, 150, "..."))):(($course == 'en')?strip_tags(mb_strimwidth($course->text_en, 0, 150, "...")):strip_tags(mb_strimwidth($course->text_ar, 0, 150, "..."))))
            ->meta('author',$configration->app_name)
            ->meta('time',date('D M j G:i:s T Y', strtotime($course->updated_at)))
            ->image(url("uploads/blogitems/source/$course->image"))
            ->mobile(LaravelLocalization::localizeUrl("course/" .$link))
            ->canonical(LaravelLocalization::localizeUrl("course/" .$link))
            ->shortlink(LaravelLocalization::localizeUrl("course/" .$link))
            ->meta('robots',($course->meta_robots)?'index':'noindex');
            
        $schema1 = new Schema(
            new Thing('Course', [
                'name' => $course->{'name_'.$lang},
                'description' => $course->{'meta_desc_'.$lang},
                'url' => url($lang.'/course/' . (($lang == 'en') ? $course->link_en : $course->link_ar)),
                'offers' =>'Offer',
                'provider' => new Thing('Organization', [
                    'name' => 'شركة بادر للتدريب',
                ]),
                'publisher' => new Thing('Organization', [
                    'name' => 'شركة بادر للتدريب',
                    'url' => 'https://lms.badertech.com.sa/course/',
                ])
            ])
        );
        
        $schema = new Schema(
            $schema1
        );


        return [$schema,$metatags];
    }

    public function projectsPageSeo(){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $setting = Setting::first();
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
                ->title($configration->app_name .'|'. trans('home.products'))
                ->meta('title',($seo->projects_meta_title)?substr($seo->projects_meta_title ?? '',0,60):substr($configration->app_name,0,60))
                ->description(($seo->projects_meta_desc)?substr($seo->projects_meta_desc ?? '',0,160):substr(strip_tags($configration->about_app),0,160))
                ->meta('author',$configration->app_name)
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl('/projects'))
                ->canonical(LaravelLocalization::localizeUrl('/projects'))
                ->shortlink(LaravelLocalization::localizeUrl('/projects'))
                ->meta('robots',($seo->projects_meta_robots)?'index':'noindex');

        return [$metatags];
    }

    public function servicesPageSeo($segment){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();
        if($segment == 'services') {
            $metatags
                        ->title(($seo->services_meta_title || $seo->services_meta_title_ar)?($lang=='en' ? $seo->services_meta_title ?? '' : $seo->services_meta_title_ar ?? ''):$configration->app_name)
                        ->meta('title',($seo->services_meta_title || $seo->services_meta_title_ar)?($lang=='en' ? $seo->services_meta_title ?? '' : $seo->services_meta_title_ar ?? ''):$configration->app_name)
                        ->description(($seo->services_meta_desc || $seo->services_meta_desc_ar)?($lang=='en' ? $seo->services_meta_desc ?? '' : $seo->services_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                        ->meta('author',$configration->app_name)
                        ->meta('time',date('D M j G:i:s T Y', strtotime($seo->updated_at)))
                        ->image(url("uploads/settings/source/$configration->app_logo"))
                        ->mobile(LaravelLocalization::localizeUrl('/services'))
                        ->canonical(LaravelLocalization::localizeUrl('/services'))
                        ->shortlink(LaravelLocalization::localizeUrl('/services'))
                        ->meta('robots',($seo->services_meta_robots)?'index':'noindex');
        } else {
            $metatags
                    ->title(($seo->services_meta_title || $seo->services_meta_title_ar)?($lang=='en' ? $seo->services_meta_title ?? '' : $seo->services_meta_title_ar ?? ''):$configration->app_name)
                    ->meta('title',($seo->services_meta_title || $seo->services_meta_title_ar)?($lang=='en' ? $seo->services_meta_title ?? '' : $seo->services_meta_title_ar ?? ''):$configration->app_name)
                    ->description(($seo->services_meta_desc || $seo->services_meta_desc_ar)?($lang=='en' ? $seo->services_meta_desc ?? '' : $seo->services_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                    ->meta('author',$configration->app_name)
                    ->meta('time',date('D M j G:i:s T Y', strtotime($seo->updated_at)))
                    ->image(url("uploads/settings/source/$configration->app_logo"))
                    ->mobile(LaravelLocalization::localizeUrl('/all-services'))
                    ->canonical(LaravelLocalization::localizeUrl('/all-services'))
                    ->shortlink(LaravelLocalization::localizeUrl('/all-services'))
                    ->meta('robots',($seo->services_meta_robots)?'index':'noindex');
        }

        return [$metatags];
    }

    public function projectPageSeo($link){
        $lang=\LaravelLocalization::getCurrentLocale();
        $project = Project::where('link_en',$link)->orwhere('link_ar',$link)->first();
        $configration = Configration::where('lang',$lang)->first();
        $metatags = new MetaTags();
        $metatags
                ->title(($project->meta_title_en || $project->meta_title_ar)?(($lang == 'en')? $project->meta_title_en : $project->meta_title_ar) : (($lang == 'en')?$project->name_en:$project->name_ar))
                ->meta('title',($project->meta_title_en || $project->meta_title_ar)?(($lang == 'en')? $project->meta_title_en ?? '' : $project->meta_title_ar ?? '') : (($lang == 'en')?$project->name_en ?? '':$project->name_ar ?? ''))
                ->description(($project->meta_desc_en || $project->meta_desc_ar)?(($lang == 'en')? strip_tags(mb_strimwidth($project->meta_desc_en ?? '', 0, 150, "...")) : strip_tags(mb_strimwidth($project->meta_desc_ar ?? '', 0, 150, "..."))):(($lang == 'en')?strip_tags(mb_strimwidth($project->text_en ?? '', 0, 150, "...")):strip_tags(mb_strimwidth($project->text_ar ?? '', 0, 150, "..."))))
                ->meta('author',$configration->app_name)
                ->meta('time',date('D M j G:i:s T Y', strtotime($project->updated_at)))
                ->image(url("uploads/projects/source/$project->image"))
                ->mobile(LaravelLocalization::localizeUrl("project/" .$link))
                ->canonical(LaravelLocalization::localizeUrl("project/" .$link))
                ->shortlink(LaravelLocalization::localizeUrl("project/" .$link))
                ->meta('robots',($project->meta_robots)?'index':'noindex');

        $schema = new Thing('Article', [
            'url'=> LaravelLocalization::localizeUrl("project/" .$link),
            'image'=> url("uploads/blogitems/source/$project->image"),
            'headline'=>($lang == 'en')?$project->name_en:$project->name_ar,
            'author' => new Thing('author', [
                'name'=>$configration->app_name,
                'url'=> LaravelLocalization::localizeUrl("project/" .$link),
            ]),

            'datePublished'=> $project->crated_at,
            'dateModified'=> $project->updated_at,
        ]);

        return [$schema,$metatags];
    }

    public function galleryImagesPageSeo(){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $seo = SeoAssistant::first();

        $metatags = new MetaTags();
        $metatags
                ->title(($seo->gallery_images_meta_title || $seo->gallery_images_meta_title_ar)?($lang=='en' ? $seo->gallery_images_meta_title : $seo->gallery_images_meta_title_ar):$configration->app_name)
                ->meta('title',(($seo->gallery_images_meta_title || $seo->gallery_images_meta_title_ar)?($lang=='en' ? $seo->gallery_images_meta_title ?? '' : $seo->gallery_images_meta_title_ar ?? ''):$configration->app_name))
                ->description(($seo->gallery_images_meta_desc || $seo->gallery_images_meta_desc_ar)?($lang=='en' ? $seo->gallery_images_meta_desc ?? '' : $seo->gallery_images_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                ->meta('author',$configration->app_name)
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl('/galleryImages'))
                ->canonical(LaravelLocalization::localizeUrl('/galleryImages'))
                ->shortlink(LaravelLocalization::localizeUrl('/galleryImages'))
                ->meta('robots',($seo->gallery_images_meta_robots)?'index':'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url'=> LaravelLocalization::localizeUrl("/galleryImages"),
                'image'=> url("uploads/settings/source/$configration->app_logo"),
                'headline'=> ($seo->gallery_images_meta_title)?$seo->gallery_images_meta_title:$configration->app_name,
                'author' => new Thing('author', [
                    'name'=>$configration->app_name,
                    'url'=> LaravelLocalization::localizeUrl("/galleryImages"),
                ]),
            ])
        );

        return [$schema,$metatags];
    }

    public function galleryVideosPageSeo(){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $seo = SeoAssistant::first();

        $metatags = new MetaTags();
        $metatags
                ->title(($seo->gallery_videos_meta_title || $seo->gallery_videos_meta_title_ar)?($lang=='en' ? $seo->gallery_videos_meta_title ?? '' : $seo->gallery_videos_meta_title_ar ?? ''):$configration->app_name)
                ->meta('title',(($seo->gallery_videos_meta_title || $seo->gallery_videos_meta_title_ar)?($lang=='en' ? $seo->gallery_videos_meta_title ?? '' : $seo->gallery_videos_meta_title_ar ?? ''):$configration->app_name))
                ->description(($seo->gallery_videos_meta_desc || $seo->gallery_videos_meta_desc_ar)?($lang=='en' ? $seo->gallery_videos_meta_desc ?? '' : $seo->gallery_videos_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                ->meta('author',$configration->app_name)
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl('/galleryVideos'))
                ->canonical(LaravelLocalization::localizeUrl('/galleryVideos'))
                ->shortlink(LaravelLocalization::localizeUrl('/galleryVideos'))
                ->meta('robots',($seo->gallery_videos_meta_robots)?'index':'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url'=> LaravelLocalization::localizeUrl("/galleryVideos"),
                'image'=> url("uploads/settings/source/$configration->app_logo"),
                'headline'=> ($seo->gallery_videos_meta_title)?$seo->gallery_videos_meta_title:$configration->app_name,
                'author' => new Thing('author', [
                    'name'=>$configration->app_name,
                    'url'=> LaravelLocalization::localizeUrl("/galleryVideos"),
                ]),
            ])
        );

       return [$schema,$metatags];
    }

     public function serviceSeo($link){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $faqs = Faq::get();
        $service =Service::where('link_en',$link)->orWhere('link_ar',$link)->first();
        $faqs = Faq::where('type','service')->where('service_id',$service->id)->get();


        $schema1 = new Thing('Article', [
            'url'=> LaravelLocalization::localizeUrl("service/" .$link),
            'image'=> url("uploads/settings/source/$configration->app_logo"),
            'headline'=>($service->meta_keywords)?$service->meta_keywords ?? '' : $service->name_en ?? '',
            'author' => new Thing('author', [
                'name'=>$configration->app_name,
                'url'=> LaravelLocalization::localizeUrl('/'),
            ]),

            'datePublished'=> $service->crated_at,
            'dateModified'=> $service->updated_at,
        ]);
        if(count($faqs) > 0){
        $ques = [];
        foreach($faqs as $faq){
            $x = new Thing('Question', [
                'name'=>$faq->question,
                'acceptedAnswer' => new Thing('Answer', [
                    'text'=>$faq->answer,
                ]),
            ]);

            array_push($ques,$x);
        }

        $schema2 = new Thing('FAQPage', [
            'mainEntity' =>[
                $ques
            ]

        ]);

        $schema = new Schema(
            $schema1,
            $schema2
        );
        }else{
            $schema = new Schema(
                $schema1
            );
        }

        $metatags = new MetaTags();
        $metatags
                ->title(($service->meta_title_en || $service->meta_title_ar)?(($lang == 'en')? $service->meta_title_en ?? '' : $service->meta_title_ar ?? '') : (($lang == 'en')?$service->name_en ?? '':$service->name_ar ?? ''))
                ->meta('title',($service->meta_title_en || $service->meta_title_ar)?(($lang == 'en')? $service->meta_title_en ?? '' : $service->meta_title_ar ?? '') : (($lang == 'en')?$service->name_en ?? '':$service->name_ar ?? ''))
                ->description(($service->meta_desc_en || $service->meta_desc_ar)?(($lang == 'en')? strip_tags(mb_strimwidth($service->meta_desc_en ?? '', 0, 150, "...")) : strip_tags(mb_strimwidth($service->meta_desc_ar ?? '', 0, 150, "..."))):(($lang == 'en')?strip_tags(mb_strimwidth($service->text_en ?? '', 0, 150, "...")):strip_tags(mb_strimwidth($service->text_ar ?? '', 0, 150, "..."))))
                ->meta('author',$configration->app_name)
                ->meta('time',date('D M j G:i:s T Y', strtotime($service->updated_at)))
                ->image(url("uploads/services/source/$service->img"))
                ->mobile(LaravelLocalization::localizeUrl("service/" .$link))
                ->canonical(LaravelLocalization::localizeUrl("service/" .$link))
                ->shortlink(LaravelLocalization::localizeUrl("service/" .$link))
                ->meta('robots',($service->meta_robots)?'index':'noindex');

        return [$schema,$metatags];
     }

     public function coursesPageSeo($link=null){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();
        
        if($link) {
            $metatags
                ->title(($seo->courses_meta_title||$seo->courses_meta_title_ar)?(($lang == 'en')?$seo->courses_meta_title ?? '':$seo->courses_meta_title_ar ?? ''):$configration->app_name)
                ->meta('title',($seo->courses_meta_title||$seo->courses_meta_title_ar)?(($lang == 'en')?$seo->courses_meta_title ?? '':$seo->courses_meta_title_ar ?? ''):$configration->app_name)
                ->description(($seo->courses_meta_desc||$seo->courses_meta_desc_ar)?(($lang == 'en')?$seo->courses_meta_desc ?? '':$seo->courses_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                ->meta('author',$configration->app_name)
                ->meta('time',date('D M j G:i:s T Y', strtotime($seo->updated_at)))
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl("/courses/$link"))
                ->canonical(LaravelLocalization::localizeUrl("/courses/$link"))
                ->shortlink(LaravelLocalization::localizeUrl("/courses/$link"))
                ->meta('robots',($seo->courses_meta_robots)?'index':'noindex');
        } else {

            $metatags
                    ->title(($seo->courses_meta_title||$seo->courses_meta_title_ar)?(($lang == 'en')?$seo->courses_meta_title ?? '':$seo->courses_meta_title_ar ?? ''):$configration->app_name)
                    ->meta('title',($seo->courses_meta_title||$seo->courses_meta_title_ar)?(($lang == 'en')?$seo->courses_meta_title ?? '':$seo->courses_meta_title_ar ?? ''):$configration->app_name)
                    ->description(($seo->courses_meta_desc||$seo->courses_meta_desc_ar)?(($lang == 'en')?$seo->courses_meta_desc ?? '':$seo->courses_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                    ->meta('author',$configration->app_name)
                    ->meta('time',date('D M j G:i:s T Y', strtotime($seo->updated_at)))
                    ->image(url("uploads/settings/source/$configration->app_logo"))
                    ->mobile(LaravelLocalization::localizeUrl('/courses'))
                    ->canonical(LaravelLocalization::localizeUrl('/courses'))
                    ->shortlink(LaravelLocalization::localizeUrl('/courses'))
                    ->meta('robots',($seo->courses_meta_robots)?'index':'noindex');
    
        }
        return [$metatags];
    }
    
    public function categoryCoursesPageSeo($link){
        $lang=\LaravelLocalization::getCurrentLocale();
        $configration = Configration::where('lang',$lang)->first();
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
                ->title(($seo->courses_meta_title||$seo->courses_meta_title_ar)?(($lang == 'en')?$seo->courses_meta_title ?? '':$seo->courses_meta_title_ar ?? ''):$configration->app_name)
                ->meta('title',($seo->courses_meta_title||$seo->courses_meta_title_ar)?(($lang == 'en')?$seo->courses_meta_title ?? '':$seo->courses_meta_title_ar ?? ''):$configration->app_name)
                ->description(($seo->courses_meta_desc||$seo->courses_meta_desc_ar)?(($lang == 'en')?$seo->courses_meta_desc ?? '':$seo->courses_meta_desc_ar ?? ''):strip_tags($configration->about_app))
                ->meta('author',$configration->app_name)
                ->meta('time',date('D M j G:i:s T Y', strtotime($seo->updated_at)))
                ->image(url("uploads/settings/source/$configration->app_logo"))
                ->mobile(LaravelLocalization::localizeUrl("/category/$link"))
                ->canonical(LaravelLocalization::localizeUrl("/category/$link"))
                ->shortlink(LaravelLocalization::localizeUrl("/category/$link"))
                ->meta('robots',($seo->courses_meta_robots)?'index':'noindex');

        return [$metatags];
    }


}
