<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TrainingCourse extends Model
{
    protected $table = 'trainings_courses';
    protected $guarded = [];
 
    public $timestamps = false;

    public function course_info(){
        return $this->belongsTo(Course::class,'course_id');
    }
    public function student_lessons() {
        return $this->hasMany(Lesson::class, 'course_id','course_id')->where('status', 1)->orderBy('id', 'asc');
    }
    public function instructor_info(){
        return $this->hasOne(InstructorInfo::class,'user_id','instructor_id');
    }
}
