<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TrainingAttendance extends Model
{
    protected $table = 'training_attendance';
    protected $guarded =[];  
    public $timstamps = false;
    public function user(){
        return $this->belongsTo(User::class);
    }
    public function training(){
        return $this->belongsTo(Training::class);
    }
    public function attachments(){
        return $this->hasMany(TrainingAttendanceAttachments::class,'training_attendance_id');
    }
    
    public function student_info(){
        return $this->hasOne(StudentInfo::class,'user_id');
    }
    
    
     
}
