<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class CrmTask extends Model
{
    protected $table = 'crm_tasks';
    protected $guarded= [];
    protected $casts= [
        "employee"=>"array"
    ];
    
    public function getTypeAttribute()
    {
        $date_now = Carbon::now()->toDateString(); // Get current date as Y-m-d string
        $notify_date = Carbon::parse($this->notify_date)->toDateString(); // Convert notify_date to Y-m-d
    
        $types = [];
    
        if ($notify_date === $date_now) {
            $types[] = "today";
        }
    
        if ($this->status == "delayed" || $notify_date < $date_now) {
            $types[] = "delayed";
        }
    
        if ($notify_date > $date_now) {
            $types[] = "next";
        }
    
        return $types;
    }

    
    public function crm_sms(){
        return $this->belongsTo(CrmSms::class,'crm_sms_id')->with('client');
    }
    
    public function employees(){
        return User::whereIn('id',$this->employee)->get(); 
    } 
    
}
