<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CrmCompanyData extends Model
{
    protected $table = 'crm_companies_data';
    protected $guarded = [];
    public function clients(){
        return $this->hasMany(CrmClient::class,'company_id');
    }
    public function owner(){
        return $this->belongsTo(CrmClient::class,'crm_client_id');
    }
    
    public function field(){
        return $this->belongsTo(CrmField::class,'field_id');
    }
    
    public function area(){
        return $this->belongsTo(Area::class,'area_id');
    }
    public function region(){
        return $this->belongsTo(Region::class,'region_id');
    }
    

}
