<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use App;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class Course extends Model
{
    protected $guarded=[];

    public function getRouteKeyName(): string
    {
        $locale = LaravelLocalization::getCurrentLocale();
        return 'link_' . $locale;
    }
    
    public function level(){
        return $this->belongsTo(Level::class);
    }
    
    public function trainings(){
        return $this->hasMany(Training::class,'course_id');
    }

    public function category(){
        return $this->belongsTo(Category::class);
    }
    public function type(){
        return $this->belongsTo(Type::class);
    }

    public function countHistoryLessons($user_id){
        return $this->hasMany(LessonHistory::class)->where('user_id',$user_id)->count();
    }
    public function points(){
        $points = CoursePoint::whereIN('id',json_decode($this->course_point_id))->get();
        return $points;
    }
    public function include_materials(){
        $course_materials = CourseMaterial::whereIN('id',json_decode($this->course_material_id))->get();
        return $course_materials;
    }
    public function course_requirments(){
        $course_requirments = CourseRequirment::whereIN('id',json_decode($this->course_requirment_id))->get();
        return $course_requirments;
    }
    public function teachers(){
        $teacher_ids = json_decode($this->teacher_id);
        return Teacher::whereIn('id',$teacher_ids)->get();
    }

    public function discount(){
        return $this->hasOne(CourseDiscount::class, 'course_id')->where(DB::raw('DATE(end_date)'), '>', Carbon::now()->toDateString());
    }
    public function website_discount(){
        return $this->hasOne(CourseDiscount::class,'course_id')->where(DB::raw('DATE(end_date)'), '>', Carbon::now()->toDateString());
    }

    public function last_price(){
        $discount = $this->website_discount;
        if($discount){
            return ($this->price - $discount->value);
        }else{
            return $this->price;
        }
    }

    public function chapters(){
        return $this->hasMany(Chapter::class,'course_id')->with('lessons','exame')->orderBy('order');
    }
    public function countLessons(){
        return $this->hasMany(Lesson::class,'course_id')->count();
    }
    

    public function reviews(){
        return $this->hasMany(CourseReview::class);
    }

    public function my_certificate(){
        return $this->hasOne(Certificate::class);
    }


    public function orders(){
        return $this->hasMany(OrderCourse::class);
    }

}
