<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CenterHall extends Model
{
    protected $table = 'centers_halls';
    protected $fillable = [
        'name_en','name_ar','center_id','capacity','logo','type','map_url','address_en','address_ar'
    ];
    public $timestamps = false;

    public function center() {
        return $this->belongsTo(Center::class,'center_id');
    }
    
    public function country() {
        return $this->belongsTo(Country::class,'country_id');
    }
    
    public function region() {
        return $this->belongsTo(Region::class,'region_id');
    }
    
    public function area() {
        return $this->belongsTo(Area::class,'area_id');
    }
    
}
