<?php

namespace App\Models;
use App\ModelsProject;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $table = 'categories';

    public function subCategories(){
        return Category::where('parent_id',$this->id)->get();
    }

    public function coursesCount($levels = null)
    {
        $query = Training::where('category_id', $this->id)->where('status', 1);
        
        if ($levels && count($levels) > 0) {
            $query->where(function($query) use ($levels) {
                foreach ($levels as $level) {
                    $query->where('level_id', $level);
                }
            });
        }
        return $query->count();
    }

    public function courses(){
        return $this->hasMany(Training::class);
    } 

}
