<?php

namespace App\Imports;

use App\Models\StudentInfo;
use App\Models\SurvayResult;
use App\Models\Training;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithUpserts;

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class SurveyResultImport implements ToModel, WithStartRow
{
    
    public function model(array $row)
    {
        if (!isset($row[0])) {
            return null;
        }
    
        $training = Training::where('code',$row[0])->first();
        $user = StudentInfo::where('ssn', $row[2])->first();
        
        if(!$training || !$user) {
            return null;
        }
        
        $questions = [13,14,15,16,18,19,20,21,22,23,24,26,27,28,29,30,31,32];
        
        $student_answers = SurvayResult::where('user_id',$user->user_id)->where('training_id',$training->id)->orderBy('survay_question_id','ASC')->get();
        
        if(count($student_answers) > 0) {
            foreach($student_answers as $index => $q_answer) {
                // foreach($questions as $index => $q) {
                     $q_answer->update([
                        'answer' => $row[$index+3],
                    ]);
                // }
            }
        } else {
            
            foreach($questions as $index => $q) {
                 SurvayResult::create([
                    'user_id' => $user->user_id,
                    'training_id' => $training->id,
                    'survay_id' => 11,
                    'survay_question_id' => $q,
                    'answer' => $row[$index+3],
                ]);
            }
      }
    }

    public function startRow(): int
    {
        return 2;
    }

}

