<?php

namespace App\Imports;

use App\Models\StudentAddress;
use App\Models\Student;
use App\Models\StudentInfo;
use App\Models\Training;
use App\Models\Region;
use App\Models\Country;
use App\Models\Area;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithUpserts;

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class StudentImport implements ToModel, WithStartRow
{
    public function model(array $row)
    {
        if ($row[0] == "") {
            return null;
        }

        $user_data = User::where('email', $row[4])->first();
        $area = Area::where('name_ar', $row[10])->first();
        $region = Region::where('name_ar', $row[11])->first();
        $training = Training::where('code', $row[1])->first();

        if (empty($region) || empty($area) || empty($training)|| empty($row[9])) {
            return null;
        }

        if ($user_data) {
            // Update existing user
            $user_data->update([
                'f_name' => $row[3],
                'email' => $row[4],
                'password' => bcrypt($row[9]),
                'verification_code' => rand(111111, 999999),
                'type' => 'student',
                'device_type' => 'web',
                'status' => 1,
                'created_by' => auth()->user()->id,
            ]);

            $student_info = StudentInfo::where('user_id', $user_data->id)->first();
            $student_info->update([
                'ssn' => $row[4],
                'mobile' => $row[9],
                'whatsapp' => $row[9],
                'general_specialization' => $row[12],
                'accurate_specialization' => $row[13],
                'job_title_ksa_classification' => $row[6], // المسمى الوظيفي حسب التصنيف المهني السعودي
                'job_title_Insurances' => $row[5], // المسمى الوظيفي في التامينات
                'qualification' => $row[8],
                'company' => $row[15],
                'student_status' => $row[14],
                'registration_date' => Date::excelToDateTimeObject($row[7]),
                'created_by' => auth()->user()->id,
            ]);

            $student_address = StudentAddress::where('student_id', $student_info->id)->first();
            $student_address->update([
                'region_id' => $region->id,
                'area_id' => $area->id,
                'address' => '',
                'building_num' => '',
                'flat_num' => '',
                'land_mark' => '',
                'created_by' => auth()->user()->id,
            ]);

            $serial = "SN-" . $training->code . '-' . $user_data->id;
            $qrCodeFilePath = $this->createQRCode($serial);
            Student::where('user_id', $user_data->id)->update([
                'training_id' => $training->id,
                'certificate_serial' => $serial,
                'certificate_qrcode' => $qrCodeFilePath,
                'created_by' => auth()->user()->id,
            ]);
        } else {
            // Create new user
            $user = User::create([
                'f_name' => $row[3],
                'email' => $row[4],
                'password' => bcrypt($row[9]),
                'verification_code' => rand(111111, 999999),
                'type' => 'student',
                'device_type' => 'web',
                'status' => 1,
                'created_by' => auth()->user()->id,
            ]);
            $user->assignRole('متدرب / Trainee');

            $student_info = StudentInfo::create([
                'user_id' => $user->id,
                'ssn' => $row[4],
                'mobile' => $row[9],
                'whatsapp' => $row[9],
                'general_specialization' => $row[12],
                'accurate_specialization' => $row[13],
                'job_title_ksa_classification' => $row[6], // المسمى الوظيفي حسب التصنيف المهني السعودي
                'job_title_Insurances' => $row[5], // المسمى الوظيفي في التامينات
                'qualification' => $row[8],
                'company' => $row[15],
                'student_status' => $row[14],
                'registration_date' => Date::excelToDateTimeObject($row[7]),
                'created_by' => auth()->user()->id,
            ]);

            $student_address = StudentAddress::create([
                'student_id' => $student_info->id,
                'country_id' => Country::where('name_ar', 'السعودية')->orWhere('name_ar', 'السعوديه')->first()->id ?? null,
                'region_id' => $region->id,
                'area_id' => $area->id,
                'address' => '',
                'building_num' => '',
                'flat_num' => '',
                'land_mark' => '',
                'created_by' => auth()->user()->id,
            ]);

            $serial = "SN-" . $training->code . '-' . $user->id;
            $qrCodeFilePath = $this->createQRCode($serial);
            Student::create([
                'user_id' => $user->id,
                'training_id' => $training->id,
                'certificate_serial' => $serial,
                'certificate_qrcode' => $qrCodeFilePath,
                'created_by' => auth()->user()->id,
            ]);
        }
    }

    public function startRow(): int
    {
        return 2;
    }

    public function createQRCode($serial)
    {
        $writer = new PngWriter();
        $qrCode = QrCode::create(url('certificate/' . $serial))
            ->setEncoding(new Encoding('UTF-8'))
            ->setErrorCorrectionLevel(ErrorCorrectionLevel::Low)
            ->setSize(100)
            ->setMargin(10)
            ->setRoundBlockSizeMode(RoundBlockSizeMode::Margin)
            ->setForegroundColor(new Color(0, 0, 0))
            ->setBackgroundColor(new Color(255, 255, 255));

        $result = $writer->write($qrCode);
        $filePath = base_path("uploads/students/trainingCertificatesQRCodes/$serial-qrCode.png");
        $result->saveToFile($filePath);

        return "$serial-qrCode.png";
    }
}
