<?php

namespace App\Imports;

use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithUpserts;
use App\Models\CrmClient;
use App\Models\CrmCompanyData;


use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class CrmCompanyImport implements ToModel, WithStartRow
{
    public function model(array $row)
    {
        if ($row[0] == "") {
            return null;
        }
        
        $crm_client_old =CrmClient::where('phone',$row[3])->orwhere('email',$row[1])->first();

        if ($crm_client_old) {
            return null; 
        }

        // Create new CrmClient
        $crm_client_new = CrmClient::create([
            'name' => $row[0],
            'email' => $row[1],
            'ssn' => $row[2],
            'phone' => $row[3],
            'phone2' => $row[4],
            'whatsapp' => $row[5],
            'nationality' => $row[6],
            'come_from' => $row[8],
            'type' => "company",
        ]);
        CrmCompanyData::create([
            'crm_client_id'=>$crm_client_new->id,
            'responsible_contact_person'=>$row[7],
            'status_id'=>19,
            ]);
    }

    public function startRow(): int
    {
        return 2;
    }
}
