<?php

namespace App\Imports;

use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithUpserts;

use App\Models\CrmClient;
use App\Models\CrmSource;
use App\Models\Training;
use App\Models\CrmCompanyTraining;
use App\Models\CrmInvoice;

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class CrmClientsImport implements ToModel, WithStartRow
{
    public function model(array $row)
    {
        if ($row[0] == "") {
            return null;
        }
        
        $crm_client_old =CrmClient::where('phone',$row[3])->orwhere('email',$row[1])->first();
        $training =Training::where('name_ar',trim($row[10]))->orwhere('name_en',trim($row[10]))->first();
       
        if($training && !$crm_client_old){
            
            $source = CrmSource::where('name_en',$row[9])->orWhere('name_ar',$row[9])->first();
            // Create new CrmClient
            $crm_client_new = CrmClient::create([
                'name' => $row[0],
                'email' => $row[1],
                'ssn' => $row[2],
                'phone' => $row[3],
                'phone2' => $row[4],
                'whatsapp' => $row[5],
                'qualification' => $row[6],
                'nationality' => $row[7],
                'job' => $row[8],
                'come_from' => $source?$source->id:null,
                "type"=>"client",
                'status_id'=>19
            ]);
            if($training){
                $training_company = CrmCompanyTraining::create([
                    'company_id'=> $crm_client_new->id,
                    'training_id'=> $training->id,
                ]);
                
                CrmInvoice::create([
                    'client_id'=>$crm_client_new->id,
                    'invoice_number'=>random_int(100000000, 999999999),
                    'crm_company_tranining_id'=> $training_company->id,
                    'invoice_value'=>$training->price,
                    'training_cost'=>$training->price,
                    'duration_days'=>$training->overall_days,
                    'invoice_status'=>'in_training'
                ]);
            }
        }
        
    }

    public function startRow(): int
    {
        return 2;
    }
}
